/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a Crawler node present in the workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrawlerNodeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CrawlerNodeDetails.Builder, CrawlerNodeDetails> {
    private static final SdkField<List<Crawl>> CRAWLS_FIELD = SdkField
            .<List<Crawl>> builder(MarshallingType.LIST)
            .memberName("Crawls")
            .getter(getter(CrawlerNodeDetails::crawls))
            .setter(setter(Builder::crawls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Crawls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Crawl> builder(MarshallingType.SDK_POJO)
                                            .constructor(Crawl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Crawl> crawls;

    private CrawlerNodeDetails(BuilderImpl builder) {
        this.crawls = builder.crawls;
    }

    /**
     * Returns true if the Crawls property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCrawls() {
        return crawls != null && !(crawls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of crawls represented by the crawl node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCrawls()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of crawls represented by the crawl node.
     */
    public final List<Crawl> crawls() {
        return crawls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCrawls() ? crawls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerNodeDetails)) {
            return false;
        }
        CrawlerNodeDetails other = (CrawlerNodeDetails) obj;
        return hasCrawls() == other.hasCrawls() && Objects.equals(crawls(), other.crawls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrawlerNodeDetails").add("Crawls", hasCrawls() ? crawls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Crawls":
            return Optional.ofNullable(clazz.cast(crawls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrawlerNodeDetails, T> g) {
        return obj -> g.apply((CrawlerNodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrawlerNodeDetails> {
        /**
         * <p>
         * A list of crawls represented by the crawl node.
         * </p>
         * 
         * @param crawls
         *        A list of crawls represented by the crawl node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawls(Collection<Crawl> crawls);

        /**
         * <p>
         * A list of crawls represented by the crawl node.
         * </p>
         * 
         * @param crawls
         *        A list of crawls represented by the crawl node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawls(Crawl... crawls);

        /**
         * <p>
         * A list of crawls represented by the crawl node.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Crawl>.Builder} avoiding the need to create
         * one manually via {@link List<Crawl>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Crawl>.Builder#build()} is called immediately and its result
         * is passed to {@link #crawls(List<Crawl>)}.
         * 
         * @param crawls
         *        a consumer that will call methods on {@link List<Crawl>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawls(List<Crawl>)
         */
        Builder crawls(Consumer<Crawl.Builder>... crawls);
    }

    static final class BuilderImpl implements Builder {
        private List<Crawl> crawls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerNodeDetails model) {
            crawls(model.crawls);
        }

        public final List<Crawl.Builder> getCrawls() {
            List<Crawl.Builder> result = CrawlListCopier.copyToBuilder(this.crawls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder crawls(Collection<Crawl> crawls) {
            this.crawls = CrawlListCopier.copy(crawls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawls(Crawl... crawls) {
            crawls(Arrays.asList(crawls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawls(Consumer<Crawl.Builder>... crawls) {
            crawls(Stream.of(crawls).map(c -> Crawl.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCrawls(Collection<Crawl.BuilderImpl> crawls) {
            this.crawls = CrawlListCopier.copyFromBuilder(crawls);
        }

        @Override
        public CrawlerNodeDetails build() {
            return new CrawlerNodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
