/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse;

public class SearchGameSessionsIterable
implements SdkIterable<SearchGameSessionsResponse> {
    private final GameLiftClient client;
    private final SearchGameSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchGameSessionsIterable(GameLiftClient client, SearchGameSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchGameSessionsResponseFetcher();
    }

    public Iterator<SearchGameSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameSession> gameSessions() {
        Function<SearchGameSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessions() != null) {
                return response.gameSessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchGameSessionsResponseFetcher
    implements SyncPageFetcher<SearchGameSessionsResponse> {
        private SearchGameSessionsResponseFetcher() {
        }

        public boolean hasNextPage(SearchGameSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchGameSessionsResponse nextPage(SearchGameSessionsResponse previousPage) {
            if (previousPage == null) {
                return SearchGameSessionsIterable.this.client.searchGameSessions(SearchGameSessionsIterable.this.firstRequest);
            }
            return SearchGameSessionsIterable.this.client.searchGameSessions((SearchGameSessionsRequest)((Object)SearchGameSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

