/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IpProtocol {
    TCP("TCP"),
    UDP("UDP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IpProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IpProtocol.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpProtocol> knownValues() {
        return Stream.of(IpProtocol.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

