/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceCredentials> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceCredentials.getter(InstanceCredentials::userName)).setter(InstanceCredentials.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceCredentials.getter(InstanceCredentials::secret)).setter(InstanceCredentials.setter(Builder::secret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Secret").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, SECRET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String secret;

    private InstanceCredentials(BuilderImpl builder) {
        this.userName = builder.userName;
        this.secret = builder.secret;
    }

    public String userName() {
        return this.userName;
    }

    public String secret() {
        return this.secret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCredentials)) {
            return false;
        }
        InstanceCredentials other = (InstanceCredentials)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.secret(), other.secret());
    }

    public String toString() {
        return ToString.builder((String)"InstanceCredentials").add("UserName", (Object)this.userName()).add("Secret", (Object)this.secret()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Secret": {
                return Optional.ofNullable(clazz.cast(this.secret()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCredentials, T> g) {
        return obj -> g.apply((InstanceCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String secret;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCredentials model) {
            this.userName(model.userName);
            this.secret(model.secret);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSecret() {
            return this.secret;
        }

        @Override
        public final Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public final void setSecret(String secret) {
            this.secret = secret;
        }

        public InstanceCredentials build() {
            return new InstanceCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceCredentials> {
        public Builder userName(String var1);

        public Builder secret(String var1);
    }
}

