/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the categorical, continuous, and integer hyperparameters, and their ranges of tunable values. The range of
 * tunable values determines which values that a hyperparameter tuning job can choose for the specified hyperparameter.
 * This object is part of the <a>HyperParameterTuningJobConfig</a> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterRanges implements SdkPojo, Serializable, ToCopyableBuilder<ParameterRanges.Builder, ParameterRanges> {
    private static final SdkField<List<CategoricalParameterRange>> CATEGORICAL_PARAMETER_RANGES_FIELD = SdkField
            .<List<CategoricalParameterRange>> builder(MarshallingType.LIST)
            .memberName("CategoricalParameterRanges")
            .getter(getter(ParameterRanges::categoricalParameterRanges))
            .setter(setter(Builder::categoricalParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalParameterRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CategoricalParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoricalParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContinuousParameterRange>> CONTINUOUS_PARAMETER_RANGES_FIELD = SdkField
            .<List<ContinuousParameterRange>> builder(MarshallingType.LIST)
            .memberName("ContinuousParameterRanges")
            .getter(getter(ParameterRanges::continuousParameterRanges))
            .setter(setter(Builder::continuousParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousParameterRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContinuousParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContinuousParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IntegerParameterRange>> INTEGER_PARAMETER_RANGES_FIELD = SdkField
            .<List<IntegerParameterRange>> builder(MarshallingType.LIST)
            .memberName("IntegerParameterRanges")
            .getter(getter(ParameterRanges::integerParameterRanges))
            .setter(setter(Builder::integerParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameterRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegerParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegerParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CATEGORICAL_PARAMETER_RANGES_FIELD, CONTINUOUS_PARAMETER_RANGES_FIELD, INTEGER_PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CategoricalParameterRange> categoricalParameterRanges;

    private final List<ContinuousParameterRange> continuousParameterRanges;

    private final List<IntegerParameterRange> integerParameterRanges;

    private ParameterRanges(BuilderImpl builder) {
        this.categoricalParameterRanges = builder.categoricalParameterRanges;
        this.continuousParameterRanges = builder.continuousParameterRanges;
        this.integerParameterRanges = builder.integerParameterRanges;
    }

    /**
     * Returns true if the CategoricalParameterRanges property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasCategoricalParameterRanges() {
        return categoricalParameterRanges != null && !(categoricalParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tunable range for each categorical hyperparameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCategoricalParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the tunable range for each categorical hyperparameter.
     */
    public final List<CategoricalParameterRange> categoricalParameterRanges() {
        return categoricalParameterRanges;
    }

    /**
     * Returns true if the ContinuousParameterRanges property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasContinuousParameterRanges() {
        return continuousParameterRanges != null && !(continuousParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tunable range for each continuous hyperparameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContinuousParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the tunable range for each continuous hyperparameter.
     */
    public final List<ContinuousParameterRange> continuousParameterRanges() {
        return continuousParameterRanges;
    }

    /**
     * Returns true if the IntegerParameterRanges property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIntegerParameterRanges() {
        return integerParameterRanges != null && !(integerParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tunable range for each integer hyperparameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIntegerParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the tunable range for each integer hyperparameter.
     */
    public final List<IntegerParameterRange> integerParameterRanges() {
        return integerParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategoricalParameterRanges() ? categoricalParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContinuousParameterRanges() ? continuousParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerParameterRanges() ? integerParameterRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterRanges)) {
            return false;
        }
        ParameterRanges other = (ParameterRanges) obj;
        return hasCategoricalParameterRanges() == other.hasCategoricalParameterRanges()
                && Objects.equals(categoricalParameterRanges(), other.categoricalParameterRanges())
                && hasContinuousParameterRanges() == other.hasContinuousParameterRanges()
                && Objects.equals(continuousParameterRanges(), other.continuousParameterRanges())
                && hasIntegerParameterRanges() == other.hasIntegerParameterRanges()
                && Objects.equals(integerParameterRanges(), other.integerParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterRanges")
                .add("CategoricalParameterRanges", hasCategoricalParameterRanges() ? categoricalParameterRanges() : null)
                .add("ContinuousParameterRanges", hasContinuousParameterRanges() ? continuousParameterRanges() : null)
                .add("IntegerParameterRanges", hasIntegerParameterRanges() ? integerParameterRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoricalParameterRanges":
            return Optional.ofNullable(clazz.cast(categoricalParameterRanges()));
        case "ContinuousParameterRanges":
            return Optional.ofNullable(clazz.cast(continuousParameterRanges()));
        case "IntegerParameterRanges":
            return Optional.ofNullable(clazz.cast(integerParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterRanges, T> g) {
        return obj -> g.apply((ParameterRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterRanges> {
        /**
         * <p>
         * Specifies the tunable range for each categorical hyperparameter.
         * </p>
         * 
         * @param categoricalParameterRanges
         *        Specifies the tunable range for each categorical hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalParameterRanges(Collection<CategoricalParameterRange> categoricalParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each categorical hyperparameter.
         * </p>
         * 
         * @param categoricalParameterRanges
         *        Specifies the tunable range for each categorical hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalParameterRanges(CategoricalParameterRange... categoricalParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each categorical hyperparameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CategoricalParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<CategoricalParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CategoricalParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #categoricalParameterRanges(List<CategoricalParameterRange>)}.
         * 
         * @param categoricalParameterRanges
         *        a consumer that will call methods on {@link List<CategoricalParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalParameterRanges(List<CategoricalParameterRange>)
         */
        Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder>... categoricalParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each continuous hyperparameter.
         * </p>
         * 
         * @param continuousParameterRanges
         *        Specifies the tunable range for each continuous hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousParameterRanges(Collection<ContinuousParameterRange> continuousParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each continuous hyperparameter.
         * </p>
         * 
         * @param continuousParameterRanges
         *        Specifies the tunable range for each continuous hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousParameterRanges(ContinuousParameterRange... continuousParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each continuous hyperparameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContinuousParameterRange>.Builder} avoiding
         * the need to create one manually via {@link List<ContinuousParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContinuousParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #continuousParameterRanges(List<ContinuousParameterRange>)}.
         * 
         * @param continuousParameterRanges
         *        a consumer that will call methods on {@link List<ContinuousParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousParameterRanges(List<ContinuousParameterRange>)
         */
        Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder>... continuousParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each integer hyperparameter.
         * </p>
         * 
         * @param integerParameterRanges
         *        Specifies the tunable range for each integer hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameterRanges(Collection<IntegerParameterRange> integerParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each integer hyperparameter.
         * </p>
         * 
         * @param integerParameterRanges
         *        Specifies the tunable range for each integer hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameterRanges(IntegerParameterRange... integerParameterRanges);

        /**
         * <p>
         * Specifies the tunable range for each integer hyperparameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntegerParameterRange>.Builder} avoiding
         * the need to create one manually via {@link List<IntegerParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntegerParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #integerParameterRanges(List<IntegerParameterRange>)}.
         * 
         * @param integerParameterRanges
         *        a consumer that will call methods on {@link List<IntegerParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerParameterRanges(List<IntegerParameterRange>)
         */
        Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder>... integerParameterRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<CategoricalParameterRange> categoricalParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<ContinuousParameterRange> continuousParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<IntegerParameterRange> integerParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterRanges model) {
            categoricalParameterRanges(model.categoricalParameterRanges);
            continuousParameterRanges(model.continuousParameterRanges);
            integerParameterRanges(model.integerParameterRanges);
        }

        public final List<CategoricalParameterRange.Builder> getCategoricalParameterRanges() {
            List<CategoricalParameterRange.Builder> result = CategoricalParameterRangesCopier
                    .copyToBuilder(this.categoricalParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder categoricalParameterRanges(Collection<CategoricalParameterRange> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copy(categoricalParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(CategoricalParameterRange... categoricalParameterRanges) {
            categoricalParameterRanges(Arrays.asList(categoricalParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder>... categoricalParameterRanges) {
            categoricalParameterRanges(Stream.of(categoricalParameterRanges)
                    .map(c -> CategoricalParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCategoricalParameterRanges(
                Collection<CategoricalParameterRange.BuilderImpl> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copyFromBuilder(categoricalParameterRanges);
        }

        public final List<ContinuousParameterRange.Builder> getContinuousParameterRanges() {
            List<ContinuousParameterRange.Builder> result = ContinuousParameterRangesCopier
                    .copyToBuilder(this.continuousParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder continuousParameterRanges(Collection<ContinuousParameterRange> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copy(continuousParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(ContinuousParameterRange... continuousParameterRanges) {
            continuousParameterRanges(Arrays.asList(continuousParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder>... continuousParameterRanges) {
            continuousParameterRanges(Stream.of(continuousParameterRanges)
                    .map(c -> ContinuousParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContinuousParameterRanges(Collection<ContinuousParameterRange.BuilderImpl> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copyFromBuilder(continuousParameterRanges);
        }

        public final List<IntegerParameterRange.Builder> getIntegerParameterRanges() {
            List<IntegerParameterRange.Builder> result = IntegerParameterRangesCopier.copyToBuilder(this.integerParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder integerParameterRanges(Collection<IntegerParameterRange> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copy(integerParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(IntegerParameterRange... integerParameterRanges) {
            integerParameterRanges(Arrays.asList(integerParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder>... integerParameterRanges) {
            integerParameterRanges(Stream.of(integerParameterRanges)
                    .map(c -> IntegerParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntegerParameterRanges(Collection<IntegerParameterRange.BuilderImpl> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copyFromBuilder(integerParameterRanges);
        }

        @Override
        public ParameterRanges build() {
            return new ParameterRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
