/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExperimentStatus {
    PENDING("pending"),
    INITIATING("initiating"),
    RUNNING("running"),
    COMPLETED("completed"),
    STOPPING("stopping"),
    STOPPED("stopped"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExperimentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExperimentStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentStatus> knownValues() {
        return Stream.of(ExperimentStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

