/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an experiment template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentTemplate.Builder, ExperimentTemplate> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ExperimentTemplate::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ExperimentTemplate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, ExperimentTemplateTarget>> TARGETS_FIELD = SdkField
            .<Map<String, ExperimentTemplateTarget>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(ExperimentTemplate::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExperimentTemplateTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ExperimentTemplateAction>> ACTIONS_FIELD = SdkField
            .<Map<String, ExperimentTemplateAction>> builder(MarshallingType.MAP)
            .memberName("actions")
            .getter(getter(ExperimentTemplate::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExperimentTemplateAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ExperimentTemplateStopCondition>> STOP_CONDITIONS_FIELD = SdkField
            .<List<ExperimentTemplateStopCondition>> builder(MarshallingType.LIST)
            .memberName("stopConditions")
            .getter(getter(ExperimentTemplate::stopConditions))
            .setter(setter(Builder::stopConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentTemplateStopCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateStopCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ExperimentTemplate::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(ExperimentTemplate::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ExperimentTemplate::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ExperimentTemplate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            TARGETS_FIELD, ACTIONS_FIELD, STOP_CONDITIONS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, ROLE_ARN_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String description;

    private final Map<String, ExperimentTemplateTarget> targets;

    private final Map<String, ExperimentTemplateAction> actions;

    private final List<ExperimentTemplateStopCondition> stopConditions;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String roleArn;

    private final Map<String, String> tags;

    private ExperimentTemplate(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.stopConditions = builder.stopConditions;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the experiment template.
     * </p>
     * 
     * @return The ID of the experiment template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The description for the experiment template.
     * </p>
     * 
     * @return The description for the experiment template.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The targets for the experiment.
     */
    public final Map<String, ExperimentTemplateTarget> targets() {
        return targets;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The actions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions for the experiment.
     */
    public final Map<String, ExperimentTemplateAction> actions() {
        return actions;
    }

    /**
     * Returns true if the StopConditions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStopConditions() {
        return stopConditions != null && !(stopConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stop conditions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStopConditions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The stop conditions for the experiment.
     */
    public final List<ExperimentTemplateStopCondition> stopConditions() {
        return stopConditions;
    }

    /**
     * <p>
     * The time the experiment template was created.
     * </p>
     * 
     * @return The time the experiment template was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the experiment template was last updated.
     * </p>
     * 
     * @return The time the experiment template was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the experiment template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the experiment template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStopConditions() ? stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplate)) {
            return false;
        }
        ExperimentTemplate other = (ExperimentTemplate) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && hasStopConditions() == other.hasStopConditions() && Objects.equals(stopConditions(), other.stopConditions())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentTemplate").add("Id", id()).add("Description", description())
                .add("Targets", hasTargets() ? targets() : null).add("Actions", hasActions() ? actions() : null)
                .add("StopConditions", hasStopConditions() ? stopConditions() : null).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "stopConditions":
            return Optional.ofNullable(clazz.cast(stopConditions()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplate, T> g) {
        return obj -> g.apply((ExperimentTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentTemplate> {
        /**
         * <p>
         * The ID of the experiment template.
         * </p>
         * 
         * @param id
         *        The ID of the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description for the experiment template.
         * </p>
         * 
         * @param description
         *        The description for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The targets for the experiment.
         * </p>
         * 
         * @param targets
         *        The targets for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, ExperimentTemplateTarget> targets);

        /**
         * <p>
         * The actions for the experiment.
         * </p>
         * 
         * @param actions
         *        The actions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Map<String, ExperimentTemplateAction> actions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(Collection<ExperimentTemplateStopCondition> stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(ExperimentTemplateStopCondition... stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExperimentTemplateStopCondition>.Builder}
         * avoiding the need to create one manually via {@link List<ExperimentTemplateStopCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExperimentTemplateStopCondition>.Builder#build()} is called
         * immediately and its result is passed to {@link #stopConditions(List<ExperimentTemplateStopCondition>)}.
         * 
         * @param stopConditions
         *        a consumer that will call methods on {@link List<ExperimentTemplateStopCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopConditions(List<ExperimentTemplateStopCondition>)
         */
        Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder>... stopConditions);

        /**
         * <p>
         * The time the experiment template was created.
         * </p>
         * 
         * @param creationTime
         *        The time the experiment template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the experiment template was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time the experiment template was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The tags for the experiment template.
         * </p>
         * 
         * @param tags
         *        The tags for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String description;

        private Map<String, ExperimentTemplateTarget> targets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ExperimentTemplateAction> actions = DefaultSdkAutoConstructMap.getInstance();

        private List<ExperimentTemplateStopCondition> stopConditions = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplate model) {
            id(model.id);
            description(model.description);
            targets(model.targets);
            actions(model.actions);
            stopConditions(model.stopConditions);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, ExperimentTemplateTarget.Builder> getTargets() {
            Map<String, ExperimentTemplateTarget.Builder> result = ExperimentTemplateTargetMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targets(Map<String, ExperimentTemplateTarget> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copy(targets);
            return this;
        }

        public final void setTargets(Map<String, ExperimentTemplateTarget.BuilderImpl> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copyFromBuilder(targets);
        }

        public final Map<String, ExperimentTemplateAction.Builder> getActions() {
            Map<String, ExperimentTemplateAction.Builder> result = ExperimentTemplateActionMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actions(Map<String, ExperimentTemplateAction> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copy(actions);
            return this;
        }

        public final void setActions(Map<String, ExperimentTemplateAction.BuilderImpl> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copyFromBuilder(actions);
        }

        public final List<ExperimentTemplateStopCondition.Builder> getStopConditions() {
            List<ExperimentTemplateStopCondition.Builder> result = ExperimentTemplateStopConditionListCopier
                    .copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stopConditions(Collection<ExperimentTemplateStopCondition> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(ExperimentTemplateStopCondition... stopConditions) {
            stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder>... stopConditions) {
            stopConditions(Stream.of(stopConditions).map(c -> ExperimentTemplateStopCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStopConditions(Collection<ExperimentTemplateStopCondition.BuilderImpl> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copyFromBuilder(stopConditions);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public ExperimentTemplate build() {
            return new ExperimentTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
