/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentSummary.Builder, ExperimentSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ExperimentSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experimentTemplateId").getter(getter(ExperimentSummary::experimentTemplateId))
            .setter(setter(Builder::experimentTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplateId").build())
            .build();

    private static final SdkField<ExperimentState> STATE_FIELD = SdkField.<ExperimentState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(ExperimentSummary::state)).setter(setter(Builder::state))
            .constructor(ExperimentState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ExperimentSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ExperimentSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            EXPERIMENT_TEMPLATE_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String experimentTemplateId;

    private final ExperimentState state;

    private final Instant creationTime;

    private final Map<String, String> tags;

    private ExperimentSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.experimentTemplateId = builder.experimentTemplateId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the experiment.
     * </p>
     * 
     * @return The ID of the experiment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the experiment template.
     * </p>
     * 
     * @return The ID of the experiment template.
     */
    public final String experimentTemplateId() {
        return experimentTemplateId;
    }

    /**
     * <p>
     * The state of the experiment.
     * </p>
     * 
     * @return The state of the experiment.
     */
    public final ExperimentState state() {
        return state;
    }

    /**
     * <p>
     * The time that the experiment was created.
     * </p>
     * 
     * @return The time that the experiment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the experiment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(experimentTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentSummary)) {
            return false;
        }
        ExperimentSummary other = (ExperimentSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(experimentTemplateId(), other.experimentTemplateId())
                && Objects.equals(state(), other.state()) && Objects.equals(creationTime(), other.creationTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentSummary").add("Id", id()).add("ExperimentTemplateId", experimentTemplateId())
                .add("State", state()).add("CreationTime", creationTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "experimentTemplateId":
            return Optional.ofNullable(clazz.cast(experimentTemplateId()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentSummary, T> g) {
        return obj -> g.apply((ExperimentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentSummary> {
        /**
         * <p>
         * The ID of the experiment.
         * </p>
         * 
         * @param id
         *        The ID of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the experiment template.
         * </p>
         * 
         * @param experimentTemplateId
         *        The ID of the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentTemplateId(String experimentTemplateId);

        /**
         * <p>
         * The state of the experiment.
         * </p>
         * 
         * @param state
         *        The state of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ExperimentState state);

        /**
         * <p>
         * The state of the experiment.
         * </p>
         * This is a convenience that creates an instance of the {@link ExperimentState.Builder} avoiding the need to
         * create one manually via {@link ExperimentState#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(ExperimentState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ExperimentState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ExperimentState)
         */
        default Builder state(Consumer<ExperimentState.Builder> state) {
            return state(ExperimentState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The time that the experiment was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the experiment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The tags for the experiment.
         * </p>
         * 
         * @param tags
         *        The tags for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String experimentTemplateId;

        private ExperimentState state;

        private Instant creationTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentSummary model) {
            id(model.id);
            experimentTemplateId(model.experimentTemplateId);
            state(model.state);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getExperimentTemplateId() {
            return experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        public final ExperimentState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(ExperimentState state) {
            this.state = state;
            return this;
        }

        public final void setState(ExperimentState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public ExperimentSummary build() {
            return new ExperimentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
