/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an action for an experiment template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExperimentTemplateActionInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateExperimentTemplateActionInput.Builder, CreateExperimentTemplateActionInput> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(CreateExperimentTemplateActionInput::actionId))
            .setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateExperimentTemplateActionInput::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(CreateExperimentTemplateActionInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TARGETS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(CreateExperimentTemplateActionInput::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> START_AFTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("startAfter")
            .getter(getter(CreateExperimentTemplateActionInput::startAfter))
            .setter(setter(Builder::startAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startAfter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            DESCRIPTION_FIELD, PARAMETERS_FIELD, TARGETS_FIELD, START_AFTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String description;

    private final Map<String, String> parameters;

    private final Map<String, String> targets;

    private final List<String> startAfter;

    private CreateExperimentTemplateActionInput(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.targets = builder.targets;
        this.startAfter = builder.startAfter;
    }

    /**
     * <p>
     * The ID of the action.
     * </p>
     * 
     * @return The ID of the action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * A description for the action.
     * </p>
     * 
     * @return A description for the action.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the action, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameters for the action, if applicable.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The targets for the action.
     */
    public final Map<String, String> targets() {
        return targets;
    }

    /**
     * Returns true if the StartAfter property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStartAfter() {
        return startAfter != null && !(startAfter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the action that must be completed before the current action starts. Omit this parameter to run the
     * action at the start of the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStartAfter()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the action that must be completed before the current action starts. Omit this parameter to
     *         run the action at the start of the experiment.
     */
    public final List<String> startAfter() {
        return startAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStartAfter() ? startAfter() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentTemplateActionInput)) {
            return false;
        }
        CreateExperimentTemplateActionInput other = (CreateExperimentTemplateActionInput) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(description(), other.description())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasStartAfter() == other.hasStartAfter() && Objects.equals(startAfter(), other.startAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExperimentTemplateActionInput").add("ActionId", actionId())
                .add("Description", description()).add("Parameters", hasParameters() ? parameters() : null)
                .add("Targets", hasTargets() ? targets() : null).add("StartAfter", hasStartAfter() ? startAfter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "startAfter":
            return Optional.ofNullable(clazz.cast(startAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentTemplateActionInput, T> g) {
        return obj -> g.apply((CreateExperimentTemplateActionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateExperimentTemplateActionInput> {
        /**
         * <p>
         * The ID of the action.
         * </p>
         * 
         * @param actionId
         *        The ID of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * A description for the action.
         * </p>
         * 
         * @param description
         *        A description for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The parameters for the action, if applicable.
         * </p>
         * 
         * @param parameters
         *        The parameters for the action, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The targets for the action.
         * </p>
         * 
         * @param targets
         *        The targets for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, String> targets);

        /**
         * <p>
         * The name of the action that must be completed before the current action starts. Omit this parameter to run
         * the action at the start of the experiment.
         * </p>
         * 
         * @param startAfter
         *        The name of the action that must be completed before the current action starts. Omit this parameter to
         *        run the action at the start of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAfter(Collection<String> startAfter);

        /**
         * <p>
         * The name of the action that must be completed before the current action starts. Omit this parameter to run
         * the action at the start of the experiment.
         * </p>
         * 
         * @param startAfter
         *        The name of the action that must be completed before the current action starts. Omit this parameter to
         *        run the action at the start of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAfter(String... startAfter);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String description;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> targets = DefaultSdkAutoConstructMap.getInstance();

        private List<String> startAfter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentTemplateActionInput model) {
            actionId(model.actionId);
            description(model.description);
            parameters(model.parameters);
            targets(model.targets);
            startAfter(model.startAfter);
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ExperimentTemplateActionParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ExperimentTemplateActionParameterMapCopier.copy(parameters);
        }

        public final Map<String, String> getTargets() {
            if (targets instanceof SdkAutoConstructMap) {
                return null;
            }
            return targets;
        }

        @Override
        public final Builder targets(Map<String, String> targets) {
            this.targets = ExperimentTemplateActionTargetMapCopier.copy(targets);
            return this;
        }

        public final void setTargets(Map<String, String> targets) {
            this.targets = ExperimentTemplateActionTargetMapCopier.copy(targets);
        }

        public final Collection<String> getStartAfter() {
            if (startAfter instanceof SdkAutoConstructList) {
                return null;
            }
            return startAfter;
        }

        @Override
        public final Builder startAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentTemplateActionStartAfterListCopier.copy(startAfter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startAfter(String... startAfter) {
            startAfter(Arrays.asList(startAfter));
            return this;
        }

        public final void setStartAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentTemplateActionStartAfterListCopier.copy(startAfter);
        }

        @Override
        public CreateExperimentTemplateActionInput build() {
            return new CreateExperimentTemplateActionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
