/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.ParquetCompression;
import software.amazon.awssdk.services.firehose.model.ParquetWriterVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParquetSerDe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParquetSerDe> {
    private static final SdkField<Integer> BLOCK_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockSizeBytes").getter(ParquetSerDe.getter(ParquetSerDe::blockSizeBytes)).setter(ParquetSerDe.setter(Builder::blockSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSizeBytes").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSizeBytes").getter(ParquetSerDe.getter(ParquetSerDe::pageSizeBytes)).setter(ParquetSerDe.setter(Builder::pageSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSizeBytes").build()}).build();
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compression").getter(ParquetSerDe.getter(ParquetSerDe::compressionAsString)).setter(ParquetSerDe.setter(Builder::compression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()}).build();
    private static final SdkField<Boolean> ENABLE_DICTIONARY_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableDictionaryCompression").getter(ParquetSerDe.getter(ParquetSerDe::enableDictionaryCompression)).setter(ParquetSerDe.setter(Builder::enableDictionaryCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDictionaryCompression").build()}).build();
    private static final SdkField<Integer> MAX_PADDING_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxPaddingBytes").getter(ParquetSerDe.getter(ParquetSerDe::maxPaddingBytes)).setter(ParquetSerDe.setter(Builder::maxPaddingBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPaddingBytes").build()}).build();
    private static final SdkField<String> WRITER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriterVersion").getter(ParquetSerDe.getter(ParquetSerDe::writerVersionAsString)).setter(ParquetSerDe.setter(Builder::writerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriterVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_SIZE_BYTES_FIELD, PAGE_SIZE_BYTES_FIELD, COMPRESSION_FIELD, ENABLE_DICTIONARY_COMPRESSION_FIELD, MAX_PADDING_BYTES_FIELD, WRITER_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer blockSizeBytes;
    private final Integer pageSizeBytes;
    private final String compression;
    private final Boolean enableDictionaryCompression;
    private final Integer maxPaddingBytes;
    private final String writerVersion;

    private ParquetSerDe(BuilderImpl builder) {
        this.blockSizeBytes = builder.blockSizeBytes;
        this.pageSizeBytes = builder.pageSizeBytes;
        this.compression = builder.compression;
        this.enableDictionaryCompression = builder.enableDictionaryCompression;
        this.maxPaddingBytes = builder.maxPaddingBytes;
        this.writerVersion = builder.writerVersion;
    }

    public final Integer blockSizeBytes() {
        return this.blockSizeBytes;
    }

    public final Integer pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public final ParquetCompression compression() {
        return ParquetCompression.fromValue(this.compression);
    }

    public final String compressionAsString() {
        return this.compression;
    }

    public final Boolean enableDictionaryCompression() {
        return this.enableDictionaryCompression;
    }

    public final Integer maxPaddingBytes() {
        return this.maxPaddingBytes;
    }

    public final ParquetWriterVersion writerVersion() {
        return ParquetWriterVersion.fromValue(this.writerVersion);
    }

    public final String writerVersionAsString() {
        return this.writerVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDictionaryCompression());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPaddingBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.writerVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParquetSerDe)) {
            return false;
        }
        ParquetSerDe other = (ParquetSerDe)obj;
        return Objects.equals(this.blockSizeBytes(), other.blockSizeBytes()) && Objects.equals(this.pageSizeBytes(), other.pageSizeBytes()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.enableDictionaryCompression(), other.enableDictionaryCompression()) && Objects.equals(this.maxPaddingBytes(), other.maxPaddingBytes()) && Objects.equals(this.writerVersionAsString(), other.writerVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ParquetSerDe").add("BlockSizeBytes", (Object)this.blockSizeBytes()).add("PageSizeBytes", (Object)this.pageSizeBytes()).add("Compression", (Object)this.compressionAsString()).add("EnableDictionaryCompression", (Object)this.enableDictionaryCompression()).add("MaxPaddingBytes", (Object)this.maxPaddingBytes()).add("WriterVersion", (Object)this.writerVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.blockSizeBytes()));
            }
            case "PageSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.pageSizeBytes()));
            }
            case "Compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "EnableDictionaryCompression": {
                return Optional.ofNullable(clazz.cast(this.enableDictionaryCompression()));
            }
            case "MaxPaddingBytes": {
                return Optional.ofNullable(clazz.cast(this.maxPaddingBytes()));
            }
            case "WriterVersion": {
                return Optional.ofNullable(clazz.cast(this.writerVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParquetSerDe, T> g) {
        return obj -> g.apply((ParquetSerDe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer blockSizeBytes;
        private Integer pageSizeBytes;
        private String compression;
        private Boolean enableDictionaryCompression;
        private Integer maxPaddingBytes;
        private String writerVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ParquetSerDe model) {
            this.blockSizeBytes(model.blockSizeBytes);
            this.pageSizeBytes(model.pageSizeBytes);
            this.compression(model.compression);
            this.enableDictionaryCompression(model.enableDictionaryCompression);
            this.maxPaddingBytes(model.maxPaddingBytes);
            this.writerVersion(model.writerVersion);
        }

        public final Integer getBlockSizeBytes() {
            return this.blockSizeBytes;
        }

        @Override
        public final Builder blockSizeBytes(Integer blockSizeBytes) {
            this.blockSizeBytes = blockSizeBytes;
            return this;
        }

        public final void setBlockSizeBytes(Integer blockSizeBytes) {
            this.blockSizeBytes = blockSizeBytes;
        }

        public final Integer getPageSizeBytes() {
            return this.pageSizeBytes;
        }

        @Override
        public final Builder pageSizeBytes(Integer pageSizeBytes) {
            this.pageSizeBytes = pageSizeBytes;
            return this;
        }

        public final void setPageSizeBytes(Integer pageSizeBytes) {
            this.pageSizeBytes = pageSizeBytes;
        }

        public final String getCompression() {
            return this.compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(ParquetCompression compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        public final Boolean getEnableDictionaryCompression() {
            return this.enableDictionaryCompression;
        }

        @Override
        public final Builder enableDictionaryCompression(Boolean enableDictionaryCompression) {
            this.enableDictionaryCompression = enableDictionaryCompression;
            return this;
        }

        public final void setEnableDictionaryCompression(Boolean enableDictionaryCompression) {
            this.enableDictionaryCompression = enableDictionaryCompression;
        }

        public final Integer getMaxPaddingBytes() {
            return this.maxPaddingBytes;
        }

        @Override
        public final Builder maxPaddingBytes(Integer maxPaddingBytes) {
            this.maxPaddingBytes = maxPaddingBytes;
            return this;
        }

        public final void setMaxPaddingBytes(Integer maxPaddingBytes) {
            this.maxPaddingBytes = maxPaddingBytes;
        }

        public final String getWriterVersion() {
            return this.writerVersion;
        }

        @Override
        public final Builder writerVersion(String writerVersion) {
            this.writerVersion = writerVersion;
            return this;
        }

        @Override
        public final Builder writerVersion(ParquetWriterVersion writerVersion) {
            this.writerVersion(writerVersion == null ? null : writerVersion.toString());
            return this;
        }

        public final void setWriterVersion(String writerVersion) {
            this.writerVersion = writerVersion;
        }

        public ParquetSerDe build() {
            return new ParquetSerDe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParquetSerDe> {
        public Builder blockSizeBytes(Integer var1);

        public Builder pageSizeBytes(Integer var1);

        public Builder compression(String var1);

        public Builder compression(ParquetCompression var1);

        public Builder enableDictionaryCompression(Boolean var1);

        public Builder maxPaddingBytes(Integer var1);

        public Builder writerVersion(String var1);

        public Builder writerVersion(ParquetWriterVersion var1);
    }
}

