/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeliveryStreamFailureType {
    RETIRE_KMS_GRANT_FAILED("RETIRE_KMS_GRANT_FAILED"),
    CREATE_KMS_GRANT_FAILED("CREATE_KMS_GRANT_FAILED"),
    KMS_ACCESS_DENIED("KMS_ACCESS_DENIED"),
    DISABLED_KMS_KEY("DISABLED_KMS_KEY"),
    INVALID_KMS_KEY("INVALID_KMS_KEY"),
    KMS_KEY_NOT_FOUND("KMS_KEY_NOT_FOUND"),
    KMS_OPT_IN_REQUIRED("KMS_OPT_IN_REQUIRED"),
    CREATE_ENI_FAILED("CREATE_ENI_FAILED"),
    DELETE_ENI_FAILED("DELETE_ENI_FAILED"),
    SUBNET_NOT_FOUND("SUBNET_NOT_FOUND"),
    SECURITY_GROUP_NOT_FOUND("SECURITY_GROUP_NOT_FOUND"),
    ENI_ACCESS_DENIED("ENI_ACCESS_DENIED"),
    SUBNET_ACCESS_DENIED("SUBNET_ACCESS_DENIED"),
    SECURITY_GROUP_ACCESS_DENIED("SECURITY_GROUP_ACCESS_DENIED"),
    UNKNOWN_ERROR("UNKNOWN_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeliveryStreamFailureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryStreamFailureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeliveryStreamFailureType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryStreamFailureType> knownValues() {
        return Stream.of(DeliveryStreamFailureType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

