/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersResponse;
import software.amazon.awssdk.services.emrcontainers.model.JobRun;
import software.amazon.awssdk.services.emrcontainers.model.JobRunsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobRunsResponse
extends EmrContainersResponse
implements ToCopyableBuilder<Builder, ListJobRunsResponse> {
    private static final SdkField<List<JobRun>> JOB_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobRuns").getter(ListJobRunsResponse.getter(ListJobRunsResponse::jobRuns)).setter(ListJobRunsResponse.setter(Builder::jobRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobRunsResponse.getter(ListJobRunsResponse::nextToken)).setter(ListJobRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<JobRun> jobRuns;
    private final String nextToken;

    private ListJobRunsResponse(BuilderImpl builder) {
        super(builder);
        this.jobRuns = builder.jobRuns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobRuns() {
        return this.jobRuns != null && !(this.jobRuns instanceof SdkAutoConstructList);
    }

    public final List<JobRun> jobRuns() {
        return this.jobRuns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobRuns() ? this.jobRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobRunsResponse)) {
            return false;
        }
        ListJobRunsResponse other = (ListJobRunsResponse)((Object)obj);
        return this.hasJobRuns() == other.hasJobRuns() && Objects.equals(this.jobRuns(), other.jobRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobRunsResponse").add("JobRuns", this.hasJobRuns() ? this.jobRuns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobRuns": {
                return Optional.ofNullable(clazz.cast(this.jobRuns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobRunsResponse, T> g) {
        return obj -> g.apply((ListJobRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersResponse.BuilderImpl
    implements Builder {
        private List<JobRun> jobRuns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobRunsResponse model) {
            super(model);
            this.jobRuns(model.jobRuns);
            this.nextToken(model.nextToken);
        }

        public final List<JobRun.Builder> getJobRuns() {
            List<JobRun.Builder> result = JobRunsCopier.copyToBuilder(this.jobRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder jobRuns(Collection<JobRun> jobRuns) {
            this.jobRuns = JobRunsCopier.copy(jobRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(JobRun ... jobRuns) {
            this.jobRuns(Arrays.asList(jobRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(Consumer<JobRun.Builder> ... jobRuns) {
            this.jobRuns(Stream.of(jobRuns).map(c -> (JobRun)((JobRun.Builder)JobRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobRuns(Collection<JobRun.BuilderImpl> jobRuns) {
            this.jobRuns = JobRunsCopier.copyFromBuilder(jobRuns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobRunsResponse build() {
            return new ListJobRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrContainersResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobRunsResponse> {
        public Builder jobRuns(Collection<JobRun> var1);

        public Builder jobRuns(JobRun ... var1);

        public Builder jobRuns(Consumer<JobRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

