/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection;
import software.amazon.awssdk.services.elastictranscoder.model.OutputKeysCopier;
import software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobPlaylist
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateJobPlaylist> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateJobPlaylist.getter(CreateJobPlaylist::name)).setter(CreateJobPlaylist.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(CreateJobPlaylist.getter(CreateJobPlaylist::format)).setter(CreateJobPlaylist.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<List<String>> OUTPUT_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputKeys").getter(CreateJobPlaylist.getter(CreateJobPlaylist::outputKeys)).setter(CreateJobPlaylist.setter(Builder::outputKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HlsContentProtection> HLS_CONTENT_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsContentProtection").getter(CreateJobPlaylist.getter(CreateJobPlaylist::hlsContentProtection)).setter(CreateJobPlaylist.setter(Builder::hlsContentProtection)).constructor(HlsContentProtection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsContentProtection").build()}).build();
    private static final SdkField<PlayReadyDrm> PLAY_READY_DRM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlayReadyDrm").getter(CreateJobPlaylist.getter(CreateJobPlaylist::playReadyDrm)).setter(CreateJobPlaylist.setter(Builder::playReadyDrm)).constructor(PlayReadyDrm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayReadyDrm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD, OUTPUT_KEYS_FIELD, HLS_CONTENT_PROTECTION_FIELD, PLAY_READY_DRM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String format;
    private final List<String> outputKeys;
    private final HlsContentProtection hlsContentProtection;
    private final PlayReadyDrm playReadyDrm;

    private CreateJobPlaylist(BuilderImpl builder) {
        this.name = builder.name;
        this.format = builder.format;
        this.outputKeys = builder.outputKeys;
        this.hlsContentProtection = builder.hlsContentProtection;
        this.playReadyDrm = builder.playReadyDrm;
    }

    public final String name() {
        return this.name;
    }

    public final String format() {
        return this.format;
    }

    public final boolean hasOutputKeys() {
        return this.outputKeys != null && !(this.outputKeys instanceof SdkAutoConstructList);
    }

    public final List<String> outputKeys() {
        return this.outputKeys;
    }

    public final HlsContentProtection hlsContentProtection() {
        return this.hlsContentProtection;
    }

    public final PlayReadyDrm playReadyDrm() {
        return this.playReadyDrm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputKeys() ? this.outputKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsContentProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.playReadyDrm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobPlaylist)) {
            return false;
        }
        CreateJobPlaylist other = (CreateJobPlaylist)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.format(), other.format()) && this.hasOutputKeys() == other.hasOutputKeys() && Objects.equals(this.outputKeys(), other.outputKeys()) && Objects.equals(this.hlsContentProtection(), other.hlsContentProtection()) && Objects.equals(this.playReadyDrm(), other.playReadyDrm());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobPlaylist").add("Name", (Object)this.name()).add("Format", (Object)this.format()).add("OutputKeys", this.hasOutputKeys() ? this.outputKeys() : null).add("HlsContentProtection", (Object)this.hlsContentProtection()).add("PlayReadyDrm", (Object)this.playReadyDrm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "OutputKeys": {
                return Optional.ofNullable(clazz.cast(this.outputKeys()));
            }
            case "HlsContentProtection": {
                return Optional.ofNullable(clazz.cast(this.hlsContentProtection()));
            }
            case "PlayReadyDrm": {
                return Optional.ofNullable(clazz.cast(this.playReadyDrm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobPlaylist, T> g) {
        return obj -> g.apply((CreateJobPlaylist)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String format;
        private List<String> outputKeys = DefaultSdkAutoConstructList.getInstance();
        private HlsContentProtection hlsContentProtection;
        private PlayReadyDrm playReadyDrm;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobPlaylist model) {
            this.name(model.name);
            this.format(model.format);
            this.outputKeys(model.outputKeys);
            this.hlsContentProtection(model.hlsContentProtection);
            this.playReadyDrm(model.playReadyDrm);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Collection<String> getOutputKeys() {
            if (this.outputKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputKeys;
        }

        @Override
        public final Builder outputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputKeys(String ... outputKeys) {
            this.outputKeys(Arrays.asList(outputKeys));
            return this;
        }

        public final void setOutputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
        }

        public final HlsContentProtection.Builder getHlsContentProtection() {
            return this.hlsContentProtection != null ? this.hlsContentProtection.toBuilder() : null;
        }

        @Override
        public final Builder hlsContentProtection(HlsContentProtection hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection;
            return this;
        }

        public final void setHlsContentProtection(HlsContentProtection.BuilderImpl hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection != null ? hlsContentProtection.build() : null;
        }

        public final PlayReadyDrm.Builder getPlayReadyDrm() {
            return this.playReadyDrm != null ? this.playReadyDrm.toBuilder() : null;
        }

        @Override
        public final Builder playReadyDrm(PlayReadyDrm playReadyDrm) {
            this.playReadyDrm = playReadyDrm;
            return this;
        }

        public final void setPlayReadyDrm(PlayReadyDrm.BuilderImpl playReadyDrm) {
            this.playReadyDrm = playReadyDrm != null ? playReadyDrm.build() : null;
        }

        public CreateJobPlaylist build() {
            return new CreateJobPlaylist(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateJobPlaylist> {
        public Builder name(String var1);

        public Builder format(String var1);

        public Builder outputKeys(Collection<String> var1);

        public Builder outputKeys(String ... var1);

        public Builder hlsContentProtection(HlsContentProtection var1);

        default public Builder hlsContentProtection(Consumer<HlsContentProtection.Builder> hlsContentProtection) {
            return this.hlsContentProtection((HlsContentProtection)((HlsContentProtection.Builder)HlsContentProtection.builder().applyMutation(hlsContentProtection)).build());
        }

        public Builder playReadyDrm(PlayReadyDrm var1);

        default public Builder playReadyDrm(Consumer<PlayReadyDrm.Builder> playReadyDrm) {
            return this.playReadyDrm((PlayReadyDrm)((PlayReadyDrm.Builder)PlayReadyDrm.builder().applyMutation(playReadyDrm)).build());
        }
    }
}

