/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioCodecOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioCodecOptions> {
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(AudioCodecOptions.getter(AudioCodecOptions::profile)).setter(AudioCodecOptions.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profile").build()}).build();
    private static final SdkField<String> BIT_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitDepth").getter(AudioCodecOptions.getter(AudioCodecOptions::bitDepth)).setter(AudioCodecOptions.setter(Builder::bitDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitDepth").build()}).build();
    private static final SdkField<String> BIT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitOrder").getter(AudioCodecOptions.getter(AudioCodecOptions::bitOrder)).setter(AudioCodecOptions.setter(Builder::bitOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitOrder").build()}).build();
    private static final SdkField<String> SIGNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Signed").getter(AudioCodecOptions.getter(AudioCodecOptions::signed)).setter(AudioCodecOptions.setter(Builder::signed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_FIELD, BIT_DEPTH_FIELD, BIT_ORDER_FIELD, SIGNED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profile;
    private final String bitDepth;
    private final String bitOrder;
    private final String signed;

    private AudioCodecOptions(BuilderImpl builder) {
        this.profile = builder.profile;
        this.bitDepth = builder.bitDepth;
        this.bitOrder = builder.bitOrder;
        this.signed = builder.signed;
    }

    public final String profile() {
        return this.profile;
    }

    public final String bitDepth() {
        return this.bitDepth;
    }

    public final String bitOrder() {
        return this.bitOrder;
    }

    public final String signed() {
        return this.signed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profile());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.signed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioCodecOptions)) {
            return false;
        }
        AudioCodecOptions other = (AudioCodecOptions)obj;
        return Objects.equals(this.profile(), other.profile()) && Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.bitOrder(), other.bitOrder()) && Objects.equals(this.signed(), other.signed());
    }

    public final String toString() {
        return ToString.builder((String)"AudioCodecOptions").add("Profile", (Object)this.profile()).add("BitDepth", (Object)this.bitDepth()).add("BitOrder", (Object)this.bitOrder()).add("Signed", (Object)this.signed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profile()));
            }
            case "BitDepth": {
                return Optional.ofNullable(clazz.cast(this.bitDepth()));
            }
            case "BitOrder": {
                return Optional.ofNullable(clazz.cast(this.bitOrder()));
            }
            case "Signed": {
                return Optional.ofNullable(clazz.cast(this.signed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioCodecOptions, T> g) {
        return obj -> g.apply((AudioCodecOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profile;
        private String bitDepth;
        private String bitOrder;
        private String signed;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioCodecOptions model) {
            this.profile(model.profile);
            this.bitDepth(model.bitDepth);
            this.bitOrder(model.bitOrder);
            this.signed(model.signed);
        }

        public final String getProfile() {
            return this.profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final String getBitDepth() {
            return this.bitDepth;
        }

        @Override
        public final Builder bitDepth(String bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final void setBitDepth(String bitDepth) {
            this.bitDepth = bitDepth;
        }

        public final String getBitOrder() {
            return this.bitOrder;
        }

        @Override
        public final Builder bitOrder(String bitOrder) {
            this.bitOrder = bitOrder;
            return this;
        }

        public final void setBitOrder(String bitOrder) {
            this.bitOrder = bitOrder;
        }

        public final String getSigned() {
            return this.signed;
        }

        @Override
        public final Builder signed(String signed) {
            this.signed = signed;
            return this;
        }

        public final void setSigned(String signed) {
            this.signed = signed;
        }

        public AudioCodecOptions build() {
            return new AudioCodecOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioCodecOptions> {
        public Builder profile(String var1);

        public Builder bitDepth(String var1);

        public Builder bitOrder(String var1);

        public Builder signed(String var1);
    }
}

