/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Presets are templates that contain most of the settings for transcoding media files from one format to another.
 * Elastic Transcoder includes some default presets for common formats, for example, several iPod and iPhone versions.
 * You can also create your own presets for formats that aren't included among the default presets. You specify which
 * preset you want to use when you create a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Preset implements SdkPojo, Serializable, ToCopyableBuilder<Preset.Builder, Preset> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Preset::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Preset::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Preset::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Preset::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Container").getter(getter(Preset::container)).setter(setter(Builder::container))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<AudioParameters> AUDIO_FIELD = SdkField.<AudioParameters> builder(MarshallingType.SDK_POJO)
            .memberName("Audio").getter(getter(Preset::audio)).setter(setter(Builder::audio))
            .constructor(AudioParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()).build();

    private static final SdkField<VideoParameters> VIDEO_FIELD = SdkField.<VideoParameters> builder(MarshallingType.SDK_POJO)
            .memberName("Video").getter(getter(Preset::video)).setter(setter(Builder::video))
            .constructor(VideoParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<Thumbnails> THUMBNAILS_FIELD = SdkField.<Thumbnails> builder(MarshallingType.SDK_POJO)
            .memberName("Thumbnails").getter(getter(Preset::thumbnails)).setter(setter(Builder::thumbnails))
            .constructor(Thumbnails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbnails").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Preset::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CONTAINER_FIELD, AUDIO_FIELD, VIDEO_FIELD, THUMBNAILS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final String container;

    private final AudioParameters audio;

    private final VideoParameters video;

    private final Thumbnails thumbnails;

    private final String type;

    private Preset(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.container = builder.container;
        this.audio = builder.audio;
        this.video = builder.video;
        this.thumbnails = builder.thumbnails;
        this.type = builder.type;
    }

    /**
     * <p>
     * Identifier for the new preset. You use this value to get settings for the preset or to delete it.
     * </p>
     * 
     * @return Identifier for the new preset. You use this value to get settings for the preset or to delete it.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the preset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the preset.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the preset.
     * </p>
     * 
     * @return The name of the preset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the preset.
     * </p>
     * 
     * @return A description of the preset.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
     * <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>,
     * <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
     * </p>
     * 
     * @return The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
     *         <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>,
     *         <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
     */
    public final String container() {
        return container;
    }

    /**
     * <p>
     * A section of the response body that provides information about the audio preset values.
     * </p>
     * 
     * @return A section of the response body that provides information about the audio preset values.
     */
    public final AudioParameters audio() {
        return audio;
    }

    /**
     * <p>
     * A section of the response body that provides information about the video preset values.
     * </p>
     * 
     * @return A section of the response body that provides information about the video preset values.
     */
    public final VideoParameters video() {
        return video;
    }

    /**
     * <p>
     * A section of the response body that provides information about the thumbnail preset values, if any.
     * </p>
     * 
     * @return A section of the response body that provides information about the thumbnail preset values, if any.
     */
    public final Thumbnails thumbnails() {
        return thumbnails;
    }

    /**
     * <p>
     * Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a preset that you
     * have defined (<code>Custom</code>).
     * </p>
     * 
     * @return Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a preset
     *         that you have defined (<code>Custom</code>).
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnails());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preset)) {
            return false;
        }
        Preset other = (Preset) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(container(), other.container())
                && Objects.equals(audio(), other.audio()) && Objects.equals(video(), other.video())
                && Objects.equals(thumbnails(), other.thumbnails()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Preset").add("Id", id()).add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("Container", container()).add("Audio", audio()).add("Video", video()).add("Thumbnails", thumbnails())
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "Audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "Thumbnails":
            return Optional.ofNullable(clazz.cast(thumbnails()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Preset, T> g) {
        return obj -> g.apply((Preset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Preset> {
        /**
         * <p>
         * Identifier for the new preset. You use this value to get settings for the preset or to delete it.
         * </p>
         * 
         * @param id
         *        Identifier for the new preset. You use this value to get settings for the preset or to delete it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the preset.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the preset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the preset.
         * </p>
         * 
         * @param name
         *        The name of the preset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the preset.
         * </p>
         * 
         * @param description
         *        A description of the preset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
         * <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>,
         * <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
         * </p>
         * 
         * @param container
         *        The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
         *        <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>,
         *        <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(String container);

        /**
         * <p>
         * A section of the response body that provides information about the audio preset values.
         * </p>
         * 
         * @param audio
         *        A section of the response body that provides information about the audio preset values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioParameters audio);

        /**
         * <p>
         * A section of the response body that provides information about the audio preset values.
         * </p>
         * This is a convenience that creates an instance of the {@link AudioParameters.Builder} avoiding the need to
         * create one manually via {@link AudioParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #audio(AudioParameters)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioParameters)
         */
        default Builder audio(Consumer<AudioParameters.Builder> audio) {
            return audio(AudioParameters.builder().applyMutation(audio).build());
        }

        /**
         * <p>
         * A section of the response body that provides information about the video preset values.
         * </p>
         * 
         * @param video
         *        A section of the response body that provides information about the video preset values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoParameters video);

        /**
         * <p>
         * A section of the response body that provides information about the video preset values.
         * </p>
         * This is a convenience that creates an instance of the {@link VideoParameters.Builder} avoiding the need to
         * create one manually via {@link VideoParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #video(VideoParameters)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoParameters)
         */
        default Builder video(Consumer<VideoParameters.Builder> video) {
            return video(VideoParameters.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * A section of the response body that provides information about the thumbnail preset values, if any.
         * </p>
         * 
         * @param thumbnails
         *        A section of the response body that provides information about the thumbnail preset values, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnails(Thumbnails thumbnails);

        /**
         * <p>
         * A section of the response body that provides information about the thumbnail preset values, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link Thumbnails.Builder} avoiding the need to create
         * one manually via {@link Thumbnails#builder()}.
         *
         * When the {@link Consumer} completes, {@link Thumbnails.Builder#build()} is called immediately and its result
         * is passed to {@link #thumbnails(Thumbnails)}.
         * 
         * @param thumbnails
         *        a consumer that will call methods on {@link Thumbnails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnails(Thumbnails)
         */
        default Builder thumbnails(Consumer<Thumbnails.Builder> thumbnails) {
            return thumbnails(Thumbnails.builder().applyMutation(thumbnails).build());
        }

        /**
         * <p>
         * Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a preset that
         * you have defined (<code>Custom</code>).
         * </p>
         * 
         * @param type
         *        Whether the preset is a default preset provided by Elastic Transcoder (<code>System</code>) or a
         *        preset that you have defined (<code>Custom</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private String container;

        private AudioParameters audio;

        private VideoParameters video;

        private Thumbnails thumbnails;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Preset model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            container(model.container);
            audio(model.audio);
            video(model.video);
            thumbnails(model.thumbnails);
            type(model.type);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getContainer() {
            return container;
        }

        @Override
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        public final AudioParameters.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        @Override
        public final Builder audio(AudioParameters audio) {
            this.audio = audio;
            return this;
        }

        public final void setAudio(AudioParameters.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        public final VideoParameters.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        @Override
        public final Builder video(VideoParameters video) {
            this.video = video;
            return this;
        }

        public final void setVideo(VideoParameters.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        public final Thumbnails.Builder getThumbnails() {
            return thumbnails != null ? thumbnails.toBuilder() : null;
        }

        @Override
        public final Builder thumbnails(Thumbnails thumbnails) {
            this.thumbnails = thumbnails;
            return this;
        }

        public final void setThumbnails(Thumbnails.BuilderImpl thumbnails) {
            this.thumbnails = thumbnails != null ? thumbnails.build() : null;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Preset build() {
            return new Preset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
