/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The captions to be created, if any.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputCaptions implements SdkPojo, Serializable, ToCopyableBuilder<InputCaptions.Builder, InputCaptions> {
    private static final SdkField<String> MERGE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergePolicy").getter(getter(InputCaptions::mergePolicy)).setter(setter(Builder::mergePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergePolicy").build()).build();

    private static final SdkField<List<CaptionSource>> CAPTION_SOURCES_FIELD = SdkField
            .<List<CaptionSource>> builder(MarshallingType.LIST)
            .memberName("CaptionSources")
            .getter(getter(InputCaptions::captionSources))
            .setter(setter(Builder::captionSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptionSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaptionSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaptionSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_POLICY_FIELD,
            CAPTION_SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mergePolicy;

    private final List<CaptionSource> captionSources;

    private InputCaptions(BuilderImpl builder) {
        this.mergePolicy = builder.mergePolicy;
        this.captionSources = builder.captionSources;
    }

    /**
     * <p>
     * A policy that determines how Elastic Transcoder handles the existence of multiple captions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions
     * for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the
     * sidecar captions and ignores the embedded captions for that language.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions
     * for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the
     * embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code> is empty,
     * Elastic Transcoder omits all sidecar captions from the output files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in
     * <code>CaptionSources</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MergePolicy</code> cannot be null.
     * </p>
     * 
     * @return A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If
     *         captions for a language are embedded in the input file and also appear in a sidecar file, Elastic
     *         Transcoder uses the sidecar captions and ignores the embedded captions for that language.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If
     *         captions for a language are embedded in the input file and also appear in a sidecar file, Elastic
     *         Transcoder uses the embedded captions and ignores the sidecar captions for that language. If
     *         <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output
     *         files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in
     *         <code>CaptionSources</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>MergePolicy</code> cannot be null.
     */
    public final String mergePolicy() {
        return mergePolicy;
    }

    /**
     * Returns true if the CaptionSources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCaptionSources() {
        return captionSources != null && !(captionSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions,
     * leave <code>CaptionSources</code> blank.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCaptionSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Source files for the input sidecar captions used during the transcoding process. To omit all sidecar
     *         captions, leave <code>CaptionSources</code> blank.
     */
    public final List<CaptionSource> captionSources() {
        return captionSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mergePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionSources() ? captionSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputCaptions)) {
            return false;
        }
        InputCaptions other = (InputCaptions) obj;
        return Objects.equals(mergePolicy(), other.mergePolicy()) && hasCaptionSources() == other.hasCaptionSources()
                && Objects.equals(captionSources(), other.captionSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputCaptions").add("MergePolicy", mergePolicy())
                .add("CaptionSources", hasCaptionSources() ? captionSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MergePolicy":
            return Optional.ofNullable(clazz.cast(mergePolicy()));
        case "CaptionSources":
            return Optional.ofNullable(clazz.cast(captionSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputCaptions, T> g) {
        return obj -> g.apply((InputCaptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputCaptions> {
        /**
         * <p>
         * A policy that determines how Elastic Transcoder handles the existence of multiple captions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If
         * captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder
         * uses the sidecar captions and ignores the embedded captions for that language.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If
         * captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder
         * uses the embedded captions and ignores the sidecar captions for that language. If <code>CaptionSources</code>
         * is empty, Elastic Transcoder omits all sidecar captions from the output files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in
         * <code>CaptionSources</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>MergePolicy</code> cannot be null.
         * </p>
         * 
         * @param mergePolicy
         *        A policy that determines how Elastic Transcoder handles the existence of multiple captions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>MergeOverride:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs.
         *        If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic
         *        Transcoder uses the sidecar captions and ignores the embedded captions for that language.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MergeRetain:</b> Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If
         *        captions for a language are embedded in the input file and also appear in a sidecar file, Elastic
         *        Transcoder uses the embedded captions and ignores the sidecar captions for that language. If
         *        <code>CaptionSources</code> is empty, Elastic Transcoder omits all sidecar captions from the output
         *        files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Override:</b> Elastic Transcoder transcodes only the sidecar captions that you specify in
         *        <code>CaptionSources</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>MergePolicy</code> cannot be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergePolicy(String mergePolicy);

        /**
         * <p>
         * Source files for the input sidecar captions used during the transcoding process. To omit all sidecar
         * captions, leave <code>CaptionSources</code> blank.
         * </p>
         * 
         * @param captionSources
         *        Source files for the input sidecar captions used during the transcoding process. To omit all sidecar
         *        captions, leave <code>CaptionSources</code> blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionSources(Collection<CaptionSource> captionSources);

        /**
         * <p>
         * Source files for the input sidecar captions used during the transcoding process. To omit all sidecar
         * captions, leave <code>CaptionSources</code> blank.
         * </p>
         * 
         * @param captionSources
         *        Source files for the input sidecar captions used during the transcoding process. To omit all sidecar
         *        captions, leave <code>CaptionSources</code> blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionSources(CaptionSource... captionSources);

        /**
         * <p>
         * Source files for the input sidecar captions used during the transcoding process. To omit all sidecar
         * captions, leave <code>CaptionSources</code> blank.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CaptionSource>.Builder} avoiding the need
         * to create one manually via {@link List<CaptionSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CaptionSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #captionSources(List<CaptionSource>)}.
         * 
         * @param captionSources
         *        a consumer that will call methods on {@link List<CaptionSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionSources(List<CaptionSource>)
         */
        Builder captionSources(Consumer<CaptionSource.Builder>... captionSources);
    }

    static final class BuilderImpl implements Builder {
        private String mergePolicy;

        private List<CaptionSource> captionSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputCaptions model) {
            mergePolicy(model.mergePolicy);
            captionSources(model.captionSources);
        }

        public final String getMergePolicy() {
            return mergePolicy;
        }

        @Override
        public final Builder mergePolicy(String mergePolicy) {
            this.mergePolicy = mergePolicy;
            return this;
        }

        public final void setMergePolicy(String mergePolicy) {
            this.mergePolicy = mergePolicy;
        }

        public final List<CaptionSource.Builder> getCaptionSources() {
            List<CaptionSource.Builder> result = CaptionSourcesCopier.copyToBuilder(this.captionSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder captionSources(Collection<CaptionSource> captionSources) {
            this.captionSources = CaptionSourcesCopier.copy(captionSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSources(CaptionSource... captionSources) {
            captionSources(Arrays.asList(captionSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSources(Consumer<CaptionSource.Builder>... captionSources) {
            captionSources(Stream.of(captionSources).map(c -> CaptionSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionSources(Collection<CaptionSource.BuilderImpl> captionSources) {
            this.captionSources = CaptionSourcesCopier.copyFromBuilder(captionSources);
        }

        @Override
        public InputCaptions build() {
            return new InputCaptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
