/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you create a pipeline, Elastic Transcoder returns the values that you specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePipelineResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<CreatePipelineResponse.Builder, CreatePipelineResponse> {
    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.<Pipeline> builder(MarshallingType.SDK_POJO)
            .memberName("Pipeline").getter(getter(CreatePipelineResponse::pipeline)).setter(setter(Builder::pipeline))
            .constructor(Pipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()).build();

    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField
            .<List<Warning>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(CreatePipelineResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Warning> builder(MarshallingType.SDK_POJO)
                                            .constructor(Warning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIPELINE_FIELD, WARNINGS_FIELD));

    private final Pipeline pipeline;

    private final List<Warning> warnings;

    private CreatePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
        this.warnings = builder.warnings;
    }

    /**
     * <p>
     * A section of the response body that provides information about the pipeline that is created.
     * </p>
     * 
     * @return A section of the response body that provides information about the pipeline that is created.
     */
    public final Pipeline pipeline() {
        return pipeline;
    }

    /**
     * Returns true if the Warnings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
     * pipeline.
     * </p>
     * <p>
     * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS KMS
     * key, reduces processing time and prevents cross-regional charges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWarnings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as
     *         the pipeline.</p>
     *         <p>
     *         Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
     *         AWS KMS key, reduces processing time and prevents cross-regional charges.
     */
    public final List<Warning> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineResponse)) {
            return false;
        }
        CreatePipelineResponse other = (CreatePipelineResponse) obj;
        return Objects.equals(pipeline(), other.pipeline()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePipelineResponse").add("Pipeline", pipeline())
                .add("Warnings", hasWarnings() ? warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineResponse, T> g) {
        return obj -> g.apply((CreatePipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePipelineResponse> {
        /**
         * <p>
         * A section of the response body that provides information about the pipeline that is created.
         * </p>
         * 
         * @param pipeline
         *        A section of the response body that provides information about the pipeline that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(Pipeline pipeline);

        /**
         * <p>
         * A section of the response body that provides information about the pipeline that is created.
         * </p>
         * This is a convenience that creates an instance of the {@link Pipeline.Builder} avoiding the need to create
         * one manually via {@link Pipeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link Pipeline.Builder#build()} is called immediately and its result is
         * passed to {@link #pipeline(Pipeline)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link Pipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(Pipeline)
         */
        default Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return pipeline(Pipeline.builder().applyMutation(pipeline).build());
        }

        /**
         * <p>
         * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
         * pipeline.
         * </p>
         * <p>
         * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS
         * KMS key, reduces processing time and prevents cross-regional charges.
         * </p>
         * 
         * @param warnings
         *        Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
         *        as the pipeline.</p>
         *        <p>
         *        Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
         *        and AWS KMS key, reduces processing time and prevents cross-regional charges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<Warning> warnings);

        /**
         * <p>
         * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
         * pipeline.
         * </p>
         * <p>
         * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS
         * KMS key, reduces processing time and prevents cross-regional charges.
         * </p>
         * 
         * @param warnings
         *        Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
         *        as the pipeline.</p>
         *        <p>
         *        Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
         *        and AWS KMS key, reduces processing time and prevents cross-regional charges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Warning... warnings);

        /**
         * <p>
         * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
         * pipeline.
         * </p>
         * <p>
         * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS
         * KMS key, reduces processing time and prevents cross-regional charges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Warning>.Builder} avoiding the need to
         * create one manually via {@link List<Warning>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Warning>.Builder#build()} is called immediately and its
         * result is passed to {@link #warnings(List<Warning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on {@link List<Warning>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(List<Warning>)
         */
        Builder warnings(Consumer<Warning.Builder>... warnings);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private Pipeline pipeline;

        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineResponse model) {
            super(model);
            pipeline(model.pipeline);
            warnings(model.warnings);
        }

        public final Pipeline.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        @Override
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> Warning.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public CreatePipelineResponse build() {
            return new CreatePipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
