/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;

public class ListElasticsearchVersionsPublisher
implements SdkPublisher<ListElasticsearchVersionsResponse> {
    private final ElasticsearchAsyncClient client;
    private final ListElasticsearchVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListElasticsearchVersionsPublisher(ElasticsearchAsyncClient client, ListElasticsearchVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListElasticsearchVersionsPublisher(ElasticsearchAsyncClient client, ListElasticsearchVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListElasticsearchVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListElasticsearchVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListElasticsearchVersionsResponseFetcher
    implements AsyncPageFetcher<ListElasticsearchVersionsResponse> {
        private ListElasticsearchVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListElasticsearchVersionsResponse> nextPage(ListElasticsearchVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchVersionsPublisher.this.client.listElasticsearchVersions(ListElasticsearchVersionsPublisher.this.firstRequest);
            }
            return ListElasticsearchVersionsPublisher.this.client.listElasticsearchVersions((ListElasticsearchVersionsRequest)((Object)ListElasticsearchVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

