/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.DomainInformation;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOutboundCrossClusterSearchConnectionRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, CreateOutboundCrossClusterSearchConnectionRequest> {
    private static final SdkField<DomainInformation> SOURCE_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDomainInfo").getter(CreateOutboundCrossClusterSearchConnectionRequest.getter(CreateOutboundCrossClusterSearchConnectionRequest::sourceDomainInfo)).setter(CreateOutboundCrossClusterSearchConnectionRequest.setter(Builder::sourceDomainInfo)).constructor(DomainInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDomainInfo").build()}).build();
    private static final SdkField<DomainInformation> DESTINATION_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationDomainInfo").getter(CreateOutboundCrossClusterSearchConnectionRequest.getter(CreateOutboundCrossClusterSearchConnectionRequest::destinationDomainInfo)).setter(CreateOutboundCrossClusterSearchConnectionRequest.setter(Builder::destinationDomainInfo)).constructor(DomainInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDomainInfo").build()}).build();
    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionAlias").getter(CreateOutboundCrossClusterSearchConnectionRequest.getter(CreateOutboundCrossClusterSearchConnectionRequest::connectionAlias)).setter(CreateOutboundCrossClusterSearchConnectionRequest.setter(Builder::connectionAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DOMAIN_INFO_FIELD, DESTINATION_DOMAIN_INFO_FIELD, CONNECTION_ALIAS_FIELD));
    private final DomainInformation sourceDomainInfo;
    private final DomainInformation destinationDomainInfo;
    private final String connectionAlias;

    private CreateOutboundCrossClusterSearchConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDomainInfo = builder.sourceDomainInfo;
        this.destinationDomainInfo = builder.destinationDomainInfo;
        this.connectionAlias = builder.connectionAlias;
    }

    public final DomainInformation sourceDomainInfo() {
        return this.sourceDomainInfo;
    }

    public final DomainInformation destinationDomainInfo() {
        return this.destinationDomainInfo;
    }

    public final String connectionAlias() {
        return this.connectionAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundCrossClusterSearchConnectionRequest)) {
            return false;
        }
        CreateOutboundCrossClusterSearchConnectionRequest other = (CreateOutboundCrossClusterSearchConnectionRequest)((Object)obj);
        return Objects.equals(this.sourceDomainInfo(), other.sourceDomainInfo()) && Objects.equals(this.destinationDomainInfo(), other.destinationDomainInfo()) && Objects.equals(this.connectionAlias(), other.connectionAlias());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOutboundCrossClusterSearchConnectionRequest").add("SourceDomainInfo", (Object)this.sourceDomainInfo()).add("DestinationDomainInfo", (Object)this.destinationDomainInfo()).add("ConnectionAlias", (Object)this.connectionAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceDomainInfo()));
            }
            case "DestinationDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.destinationDomainInfo()));
            }
            case "ConnectionAlias": {
                return Optional.ofNullable(clazz.cast(this.connectionAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundCrossClusterSearchConnectionRequest, T> g) {
        return obj -> g.apply((CreateOutboundCrossClusterSearchConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private DomainInformation sourceDomainInfo;
        private DomainInformation destinationDomainInfo;
        private String connectionAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundCrossClusterSearchConnectionRequest model) {
            super(model);
            this.sourceDomainInfo(model.sourceDomainInfo);
            this.destinationDomainInfo(model.destinationDomainInfo);
            this.connectionAlias(model.connectionAlias);
        }

        public final DomainInformation.Builder getSourceDomainInfo() {
            return this.sourceDomainInfo != null ? this.sourceDomainInfo.toBuilder() : null;
        }

        @Override
        public final Builder sourceDomainInfo(DomainInformation sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo;
            return this;
        }

        public final void setSourceDomainInfo(DomainInformation.BuilderImpl sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo != null ? sourceDomainInfo.build() : null;
        }

        public final DomainInformation.Builder getDestinationDomainInfo() {
            return this.destinationDomainInfo != null ? this.destinationDomainInfo.toBuilder() : null;
        }

        @Override
        public final Builder destinationDomainInfo(DomainInformation destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo;
            return this;
        }

        public final void setDestinationDomainInfo(DomainInformation.BuilderImpl destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo != null ? destinationDomainInfo.build() : null;
        }

        public final String getConnectionAlias() {
            return this.connectionAlias;
        }

        @Override
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOutboundCrossClusterSearchConnectionRequest build() {
            return new CreateOutboundCrossClusterSearchConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOutboundCrossClusterSearchConnectionRequest> {
        public Builder sourceDomainInfo(DomainInformation var1);

        default public Builder sourceDomainInfo(Consumer<DomainInformation.Builder> sourceDomainInfo) {
            return this.sourceDomainInfo((DomainInformation)((DomainInformation.Builder)DomainInformation.builder().applyMutation(sourceDomainInfo)).build());
        }

        public Builder destinationDomainInfo(DomainInformation var1);

        default public Builder destinationDomainInfo(Consumer<DomainInformation.Builder> destinationDomainInfo) {
            return this.destinationDomainInfo((DomainInformation)((DomainInformation.Builder)DomainInformation.builder().applyMutation(destinationDomainInfo)).build());
        }

        public Builder connectionAlias(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

