/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2instanceconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendSshPublicKeyRequest
extends Ec2InstanceConnectRequest
implements ToCopyableBuilder<Builder, SendSshPublicKeyRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SendSshPublicKeyRequest.getter(SendSshPublicKeyRequest::instanceId)).setter(SendSshPublicKeyRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INSTANCE_OS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceOSUser").getter(SendSshPublicKeyRequest.getter(SendSshPublicKeyRequest::instanceOSUser)).setter(SendSshPublicKeyRequest.setter(Builder::instanceOSUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOSUser").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSHPublicKey").getter(SendSshPublicKeyRequest.getter(SendSshPublicKeyRequest::sshPublicKey)).setter(SendSshPublicKeyRequest.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKey").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(SendSshPublicKeyRequest.getter(SendSshPublicKeyRequest::availabilityZone)).setter(SendSshPublicKeyRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INSTANCE_OS_USER_FIELD, SSH_PUBLIC_KEY_FIELD, AVAILABILITY_ZONE_FIELD));
    private final String instanceId;
    private final String instanceOSUser;
    private final String sshPublicKey;
    private final String availabilityZone;

    private SendSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.instanceOSUser = builder.instanceOSUser;
        this.sshPublicKey = builder.sshPublicKey;
        this.availabilityZone = builder.availabilityZone;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String instanceOSUser() {
        return this.instanceOSUser;
    }

    public final String sshPublicKey() {
        return this.sshPublicKey;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceOSUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendSshPublicKeyRequest)) {
            return false;
        }
        SendSshPublicKeyRequest other = (SendSshPublicKeyRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceOSUser(), other.instanceOSUser()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public final String toString() {
        return ToString.builder((String)"SendSshPublicKeyRequest").add("InstanceId", (Object)this.instanceId()).add("InstanceOSUser", (Object)this.instanceOSUser()).add("SSHPublicKey", (Object)this.sshPublicKey()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceOSUser": {
                return Optional.ofNullable(clazz.cast(this.instanceOSUser()));
            }
            case "SSHPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendSshPublicKeyRequest, T> g) {
        return obj -> g.apply((SendSshPublicKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2InstanceConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String instanceOSUser;
        private String sshPublicKey;
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(SendSshPublicKeyRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.instanceOSUser(model.instanceOSUser);
            this.sshPublicKey(model.sshPublicKey);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceOSUser() {
            return this.instanceOSUser;
        }

        @Override
        public final Builder instanceOSUser(String instanceOSUser) {
            this.instanceOSUser = instanceOSUser;
            return this;
        }

        public final void setInstanceOSUser(String instanceOSUser) {
            this.instanceOSUser = instanceOSUser;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendSshPublicKeyRequest build() {
            return new SendSshPublicKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2InstanceConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendSshPublicKeyRequest> {
        public Builder instanceId(String var1);

        public Builder instanceOSUser(String var1);

        public Builder sshPublicKey(String var1);

        public Builder availabilityZone(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

