/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;

public class DescribeVpcClassicLinkDnsSupportIterable
implements SdkIterable<DescribeVpcClassicLinkDnsSupportResponse> {
    private final Ec2Client client;
    private final DescribeVpcClassicLinkDnsSupportRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcClassicLinkDnsSupportIterable(Ec2Client client, DescribeVpcClassicLinkDnsSupportRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVpcClassicLinkDnsSupportResponseFetcher();
    }

    public Iterator<DescribeVpcClassicLinkDnsSupportResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClassicLinkDnsSupport> vpcs() {
        Function<DescribeVpcClassicLinkDnsSupportResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcs() != null) {
                return response.vpcs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcClassicLinkDnsSupportResponseFetcher
    implements SyncPageFetcher<DescribeVpcClassicLinkDnsSupportResponse> {
        private DescribeVpcClassicLinkDnsSupportResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcClassicLinkDnsSupportResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcClassicLinkDnsSupportResponse nextPage(DescribeVpcClassicLinkDnsSupportResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcClassicLinkDnsSupportIterable.this.client.describeVpcClassicLinkDnsSupport(DescribeVpcClassicLinkDnsSupportIterable.this.firstRequest);
            }
            return DescribeVpcClassicLinkDnsSupportIterable.this.client.describeVpcClassicLinkDnsSupport((DescribeVpcClassicLinkDnsSupportRequest)((Object)DescribeVpcClassicLinkDnsSupportIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

