/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpotInstanceState {
    OPEN("open"),
    ACTIVE("active"),
    CLOSED("closed"),
    CANCELLED("cancelled"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpotInstanceState> VALUE_MAP;
    private final String value;

    private SpotInstanceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpotInstanceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpotInstanceState> knownValues() {
        EnumSet<SpotInstanceState> knownValues = EnumSet.allOf(SpotInstanceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpotInstanceState.class, SpotInstanceState::toString);
    }
}

