/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetNetworkInterfaceAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ResetNetworkInterfaceAttributeRequest> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(ResetNetworkInterfaceAttributeRequest.getter(ResetNetworkInterfaceAttributeRequest::networkInterfaceId)).setter(ResetNetworkInterfaceAttributeRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDestCheck").getter(ResetNetworkInterfaceAttributeRequest.getter(ResetNetworkInterfaceAttributeRequest::sourceDestCheck)).setter(ResetNetworkInterfaceAttributeRequest.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, SOURCE_DEST_CHECK_FIELD));
    private final String networkInterfaceId;
    private final String sourceDestCheck;

    private ResetNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String sourceDestCheck() {
        return this.sourceDestCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ResetNetworkInterfaceAttributeRequest other = (ResetNetworkInterfaceAttributeRequest)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck());
    }

    public final String toString() {
        return ToString.builder((String)"ResetNetworkInterfaceAttributeRequest").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("SourceDestCheck", (Object)this.sourceDestCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetNetworkInterfaceAttributeRequest, T> g) {
        return obj -> g.apply((ResetNetworkInterfaceAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private String sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetNetworkInterfaceAttributeRequest model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.sourceDestCheck(model.sourceDestCheck);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        public final void setSourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        @Transient
        public final Builder sourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetNetworkInterfaceAttributeRequest build() {
            return new ResetNetworkInterfaceAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetNetworkInterfaceAttributeRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

