/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.HostnameType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySubnetAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifySubnetAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssignIpv6AddressOnCreation").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::assignIpv6AddressOnCreation)).setter(ModifySubnetAttributeRequest.setter(Builder::assignIpv6AddressOnCreation)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignIpv6AddressOnCreation").unmarshallLocationName("AssignIpv6AddressOnCreation").build()}).build();
    private static final SdkField<AttributeBooleanValue> MAP_PUBLIC_IP_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MapPublicIpOnLaunch").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::mapPublicIpOnLaunch)).setter(ModifySubnetAttributeRequest.setter(Builder::mapPublicIpOnLaunch)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapPublicIpOnLaunch").unmarshallLocationName("MapPublicIpOnLaunch").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::subnetId)).setter(ModifySubnetAttributeRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<AttributeBooleanValue> MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MapCustomerOwnedIpOnLaunch").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::mapCustomerOwnedIpOnLaunch)).setter(ModifySubnetAttributeRequest.setter(Builder::mapCustomerOwnedIpOnLaunch)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapCustomerOwnedIpOnLaunch").unmarshallLocationName("MapCustomerOwnedIpOnLaunch").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::customerOwnedIpv4Pool)).setter(ModifySubnetAttributeRequest.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").unmarshallLocationName("CustomerOwnedIpv4Pool").build()}).build();
    private static final SdkField<AttributeBooleanValue> ENABLE_DNS64_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnableDns64").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::enableDns64)).setter(ModifySubnetAttributeRequest.setter(Builder::enableDns64)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDns64").unmarshallLocationName("EnableDns64").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_HOSTNAME_TYPE_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsHostnameTypeOnLaunch").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::privateDnsHostnameTypeOnLaunchAsString)).setter(ModifySubnetAttributeRequest.setter(Builder::privateDnsHostnameTypeOnLaunch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsHostnameTypeOnLaunch").unmarshallLocationName("PrivateDnsHostnameTypeOnLaunch").build()}).build();
    private static final SdkField<AttributeBooleanValue> ENABLE_RESOURCE_NAME_DNS_A_RECORD_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnableResourceNameDnsARecordOnLaunch").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::enableResourceNameDnsARecordOnLaunch)).setter(ModifySubnetAttributeRequest.setter(Builder::enableResourceNameDnsARecordOnLaunch)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsARecordOnLaunch").unmarshallLocationName("EnableResourceNameDnsARecordOnLaunch").build()}).build();
    private static final SdkField<AttributeBooleanValue> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnableResourceNameDnsAAAARecordOnLaunch").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::enableResourceNameDnsAAAARecordOnLaunch)).setter(ModifySubnetAttributeRequest.setter(Builder::enableResourceNameDnsAAAARecordOnLaunch)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsAAAARecordOnLaunch").unmarshallLocationName("EnableResourceNameDnsAAAARecordOnLaunch").build()}).build();
    private static final SdkField<Integer> ENABLE_LNI_AT_DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EnableLniAtDeviceIndex").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::enableLniAtDeviceIndex)).setter(ModifySubnetAttributeRequest.setter(Builder::enableLniAtDeviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLniAtDeviceIndex").unmarshallLocationName("EnableLniAtDeviceIndex").build()}).build();
    private static final SdkField<AttributeBooleanValue> DISABLE_LNI_AT_DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisableLniAtDeviceIndex").getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::disableLniAtDeviceIndex)).setter(ModifySubnetAttributeRequest.setter(Builder::disableLniAtDeviceIndex)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableLniAtDeviceIndex").unmarshallLocationName("DisableLniAtDeviceIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD, MAP_PUBLIC_IP_ON_LAUNCH_FIELD, SUBNET_ID_FIELD, MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, ENABLE_DNS64_FIELD, PRIVATE_DNS_HOSTNAME_TYPE_ON_LAUNCH_FIELD, ENABLE_RESOURCE_NAME_DNS_A_RECORD_ON_LAUNCH_FIELD, ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_ON_LAUNCH_FIELD, ENABLE_LNI_AT_DEVICE_INDEX_FIELD, DISABLE_LNI_AT_DEVICE_INDEX_FIELD));
    private final AttributeBooleanValue assignIpv6AddressOnCreation;
    private final AttributeBooleanValue mapPublicIpOnLaunch;
    private final String subnetId;
    private final AttributeBooleanValue mapCustomerOwnedIpOnLaunch;
    private final String customerOwnedIpv4Pool;
    private final AttributeBooleanValue enableDns64;
    private final String privateDnsHostnameTypeOnLaunch;
    private final AttributeBooleanValue enableResourceNameDnsARecordOnLaunch;
    private final AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch;
    private final Integer enableLniAtDeviceIndex;
    private final AttributeBooleanValue disableLniAtDeviceIndex;

    private ModifySubnetAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.subnetId = builder.subnetId;
        this.mapCustomerOwnedIpOnLaunch = builder.mapCustomerOwnedIpOnLaunch;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.enableDns64 = builder.enableDns64;
        this.privateDnsHostnameTypeOnLaunch = builder.privateDnsHostnameTypeOnLaunch;
        this.enableResourceNameDnsARecordOnLaunch = builder.enableResourceNameDnsARecordOnLaunch;
        this.enableResourceNameDnsAAAARecordOnLaunch = builder.enableResourceNameDnsAAAARecordOnLaunch;
        this.enableLniAtDeviceIndex = builder.enableLniAtDeviceIndex;
        this.disableLniAtDeviceIndex = builder.disableLniAtDeviceIndex;
    }

    public final AttributeBooleanValue assignIpv6AddressOnCreation() {
        return this.assignIpv6AddressOnCreation;
    }

    public final AttributeBooleanValue mapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final AttributeBooleanValue mapCustomerOwnedIpOnLaunch() {
        return this.mapCustomerOwnedIpOnLaunch;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final AttributeBooleanValue enableDns64() {
        return this.enableDns64;
    }

    public final HostnameType privateDnsHostnameTypeOnLaunch() {
        return HostnameType.fromValue(this.privateDnsHostnameTypeOnLaunch);
    }

    public final String privateDnsHostnameTypeOnLaunchAsString() {
        return this.privateDnsHostnameTypeOnLaunch;
    }

    public final AttributeBooleanValue enableResourceNameDnsARecordOnLaunch() {
        return this.enableResourceNameDnsARecordOnLaunch;
    }

    public final AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch() {
        return this.enableResourceNameDnsAAAARecordOnLaunch;
    }

    public final Integer enableLniAtDeviceIndex() {
        return this.enableLniAtDeviceIndex;
    }

    public final AttributeBooleanValue disableLniAtDeviceIndex() {
        return this.disableLniAtDeviceIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapCustomerOwnedIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDns64());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsHostnameTypeOnLaunchAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableResourceNameDnsARecordOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableResourceNameDnsAAAARecordOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableLniAtDeviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableLniAtDeviceIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySubnetAttributeRequest)) {
            return false;
        }
        ModifySubnetAttributeRequest other = (ModifySubnetAttributeRequest)((Object)obj);
        return Objects.equals(this.assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation()) && Objects.equals(this.mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.mapCustomerOwnedIpOnLaunch(), other.mapCustomerOwnedIpOnLaunch()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && Objects.equals(this.enableDns64(), other.enableDns64()) && Objects.equals(this.privateDnsHostnameTypeOnLaunchAsString(), other.privateDnsHostnameTypeOnLaunchAsString()) && Objects.equals(this.enableResourceNameDnsARecordOnLaunch(), other.enableResourceNameDnsARecordOnLaunch()) && Objects.equals(this.enableResourceNameDnsAAAARecordOnLaunch(), other.enableResourceNameDnsAAAARecordOnLaunch()) && Objects.equals(this.enableLniAtDeviceIndex(), other.enableLniAtDeviceIndex()) && Objects.equals(this.disableLniAtDeviceIndex(), other.disableLniAtDeviceIndex());
    }

    public final String toString() {
        return ToString.builder((String)"ModifySubnetAttributeRequest").add("AssignIpv6AddressOnCreation", (Object)this.assignIpv6AddressOnCreation()).add("MapPublicIpOnLaunch", (Object)this.mapPublicIpOnLaunch()).add("SubnetId", (Object)this.subnetId()).add("MapCustomerOwnedIpOnLaunch", (Object)this.mapCustomerOwnedIpOnLaunch()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("EnableDns64", (Object)this.enableDns64()).add("PrivateDnsHostnameTypeOnLaunch", (Object)this.privateDnsHostnameTypeOnLaunchAsString()).add("EnableResourceNameDnsARecordOnLaunch", (Object)this.enableResourceNameDnsARecordOnLaunch()).add("EnableResourceNameDnsAAAARecordOnLaunch", (Object)this.enableResourceNameDnsAAAARecordOnLaunch()).add("EnableLniAtDeviceIndex", (Object)this.enableLniAtDeviceIndex()).add("DisableLniAtDeviceIndex", (Object)this.disableLniAtDeviceIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignIpv6AddressOnCreation": {
                return Optional.ofNullable(clazz.cast(this.assignIpv6AddressOnCreation()));
            }
            case "MapPublicIpOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.mapPublicIpOnLaunch()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "MapCustomerOwnedIpOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.mapCustomerOwnedIpOnLaunch()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "EnableDns64": {
                return Optional.ofNullable(clazz.cast(this.enableDns64()));
            }
            case "PrivateDnsHostnameTypeOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.privateDnsHostnameTypeOnLaunchAsString()));
            }
            case "EnableResourceNameDnsARecordOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.enableResourceNameDnsARecordOnLaunch()));
            }
            case "EnableResourceNameDnsAAAARecordOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.enableResourceNameDnsAAAARecordOnLaunch()));
            }
            case "EnableLniAtDeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.enableLniAtDeviceIndex()));
            }
            case "DisableLniAtDeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.disableLniAtDeviceIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySubnetAttributeRequest, T> g) {
        return obj -> g.apply((ModifySubnetAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private AttributeBooleanValue assignIpv6AddressOnCreation;
        private AttributeBooleanValue mapPublicIpOnLaunch;
        private String subnetId;
        private AttributeBooleanValue mapCustomerOwnedIpOnLaunch;
        private String customerOwnedIpv4Pool;
        private AttributeBooleanValue enableDns64;
        private String privateDnsHostnameTypeOnLaunch;
        private AttributeBooleanValue enableResourceNameDnsARecordOnLaunch;
        private AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch;
        private Integer enableLniAtDeviceIndex;
        private AttributeBooleanValue disableLniAtDeviceIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySubnetAttributeRequest model) {
            super(model);
            this.assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            this.mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            this.subnetId(model.subnetId);
            this.mapCustomerOwnedIpOnLaunch(model.mapCustomerOwnedIpOnLaunch);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.enableDns64(model.enableDns64);
            this.privateDnsHostnameTypeOnLaunch(model.privateDnsHostnameTypeOnLaunch);
            this.enableResourceNameDnsARecordOnLaunch(model.enableResourceNameDnsARecordOnLaunch);
            this.enableResourceNameDnsAAAARecordOnLaunch(model.enableResourceNameDnsAAAARecordOnLaunch);
            this.enableLniAtDeviceIndex(model.enableLniAtDeviceIndex);
            this.disableLniAtDeviceIndex(model.disableLniAtDeviceIndex);
        }

        public final AttributeBooleanValue.Builder getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation != null ? this.assignIpv6AddressOnCreation.toBuilder() : null;
        }

        public final void setAssignIpv6AddressOnCreation(AttributeBooleanValue.BuilderImpl assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation != null ? assignIpv6AddressOnCreation.build() : null;
        }

        @Override
        @Transient
        public final Builder assignIpv6AddressOnCreation(AttributeBooleanValue assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final AttributeBooleanValue.Builder getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.toBuilder() : null;
        }

        public final void setMapPublicIpOnLaunch(AttributeBooleanValue.BuilderImpl mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch != null ? mapPublicIpOnLaunch.build() : null;
        }

        @Override
        @Transient
        public final Builder mapPublicIpOnLaunch(AttributeBooleanValue mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final AttributeBooleanValue.Builder getMapCustomerOwnedIpOnLaunch() {
            return this.mapCustomerOwnedIpOnLaunch != null ? this.mapCustomerOwnedIpOnLaunch.toBuilder() : null;
        }

        public final void setMapCustomerOwnedIpOnLaunch(AttributeBooleanValue.BuilderImpl mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch != null ? mapCustomerOwnedIpOnLaunch.build() : null;
        }

        @Override
        @Transient
        public final Builder mapCustomerOwnedIpOnLaunch(AttributeBooleanValue mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch;
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        @Transient
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final AttributeBooleanValue.Builder getEnableDns64() {
            return this.enableDns64 != null ? this.enableDns64.toBuilder() : null;
        }

        public final void setEnableDns64(AttributeBooleanValue.BuilderImpl enableDns64) {
            this.enableDns64 = enableDns64 != null ? enableDns64.build() : null;
        }

        @Override
        @Transient
        public final Builder enableDns64(AttributeBooleanValue enableDns64) {
            this.enableDns64 = enableDns64;
            return this;
        }

        public final String getPrivateDnsHostnameTypeOnLaunch() {
            return this.privateDnsHostnameTypeOnLaunch;
        }

        public final void setPrivateDnsHostnameTypeOnLaunch(String privateDnsHostnameTypeOnLaunch) {
            this.privateDnsHostnameTypeOnLaunch = privateDnsHostnameTypeOnLaunch;
        }

        @Override
        @Transient
        public final Builder privateDnsHostnameTypeOnLaunch(String privateDnsHostnameTypeOnLaunch) {
            this.privateDnsHostnameTypeOnLaunch = privateDnsHostnameTypeOnLaunch;
            return this;
        }

        @Override
        @Transient
        public final Builder privateDnsHostnameTypeOnLaunch(HostnameType privateDnsHostnameTypeOnLaunch) {
            this.privateDnsHostnameTypeOnLaunch(privateDnsHostnameTypeOnLaunch == null ? null : privateDnsHostnameTypeOnLaunch.toString());
            return this;
        }

        public final AttributeBooleanValue.Builder getEnableResourceNameDnsARecordOnLaunch() {
            return this.enableResourceNameDnsARecordOnLaunch != null ? this.enableResourceNameDnsARecordOnLaunch.toBuilder() : null;
        }

        public final void setEnableResourceNameDnsARecordOnLaunch(AttributeBooleanValue.BuilderImpl enableResourceNameDnsARecordOnLaunch) {
            this.enableResourceNameDnsARecordOnLaunch = enableResourceNameDnsARecordOnLaunch != null ? enableResourceNameDnsARecordOnLaunch.build() : null;
        }

        @Override
        @Transient
        public final Builder enableResourceNameDnsARecordOnLaunch(AttributeBooleanValue enableResourceNameDnsARecordOnLaunch) {
            this.enableResourceNameDnsARecordOnLaunch = enableResourceNameDnsARecordOnLaunch;
            return this;
        }

        public final AttributeBooleanValue.Builder getEnableResourceNameDnsAAAARecordOnLaunch() {
            return this.enableResourceNameDnsAAAARecordOnLaunch != null ? this.enableResourceNameDnsAAAARecordOnLaunch.toBuilder() : null;
        }

        public final void setEnableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue.BuilderImpl enableResourceNameDnsAAAARecordOnLaunch) {
            this.enableResourceNameDnsAAAARecordOnLaunch = enableResourceNameDnsAAAARecordOnLaunch != null ? enableResourceNameDnsAAAARecordOnLaunch.build() : null;
        }

        @Override
        @Transient
        public final Builder enableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch) {
            this.enableResourceNameDnsAAAARecordOnLaunch = enableResourceNameDnsAAAARecordOnLaunch;
            return this;
        }

        public final Integer getEnableLniAtDeviceIndex() {
            return this.enableLniAtDeviceIndex;
        }

        public final void setEnableLniAtDeviceIndex(Integer enableLniAtDeviceIndex) {
            this.enableLniAtDeviceIndex = enableLniAtDeviceIndex;
        }

        @Override
        @Transient
        public final Builder enableLniAtDeviceIndex(Integer enableLniAtDeviceIndex) {
            this.enableLniAtDeviceIndex = enableLniAtDeviceIndex;
            return this;
        }

        public final AttributeBooleanValue.Builder getDisableLniAtDeviceIndex() {
            return this.disableLniAtDeviceIndex != null ? this.disableLniAtDeviceIndex.toBuilder() : null;
        }

        public final void setDisableLniAtDeviceIndex(AttributeBooleanValue.BuilderImpl disableLniAtDeviceIndex) {
            this.disableLniAtDeviceIndex = disableLniAtDeviceIndex != null ? disableLniAtDeviceIndex.build() : null;
        }

        @Override
        @Transient
        public final Builder disableLniAtDeviceIndex(AttributeBooleanValue disableLniAtDeviceIndex) {
            this.disableLniAtDeviceIndex = disableLniAtDeviceIndex;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySubnetAttributeRequest build() {
            return new ModifySubnetAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySubnetAttributeRequest> {
        public Builder assignIpv6AddressOnCreation(AttributeBooleanValue var1);

        default public Builder assignIpv6AddressOnCreation(Consumer<AttributeBooleanValue.Builder> assignIpv6AddressOnCreation) {
            return this.assignIpv6AddressOnCreation((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(assignIpv6AddressOnCreation)).build());
        }

        public Builder mapPublicIpOnLaunch(AttributeBooleanValue var1);

        default public Builder mapPublicIpOnLaunch(Consumer<AttributeBooleanValue.Builder> mapPublicIpOnLaunch) {
            return this.mapPublicIpOnLaunch((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(mapPublicIpOnLaunch)).build());
        }

        public Builder subnetId(String var1);

        public Builder mapCustomerOwnedIpOnLaunch(AttributeBooleanValue var1);

        default public Builder mapCustomerOwnedIpOnLaunch(Consumer<AttributeBooleanValue.Builder> mapCustomerOwnedIpOnLaunch) {
            return this.mapCustomerOwnedIpOnLaunch((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(mapCustomerOwnedIpOnLaunch)).build());
        }

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder enableDns64(AttributeBooleanValue var1);

        default public Builder enableDns64(Consumer<AttributeBooleanValue.Builder> enableDns64) {
            return this.enableDns64((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(enableDns64)).build());
        }

        public Builder privateDnsHostnameTypeOnLaunch(String var1);

        public Builder privateDnsHostnameTypeOnLaunch(HostnameType var1);

        public Builder enableResourceNameDnsARecordOnLaunch(AttributeBooleanValue var1);

        default public Builder enableResourceNameDnsARecordOnLaunch(Consumer<AttributeBooleanValue.Builder> enableResourceNameDnsARecordOnLaunch) {
            return this.enableResourceNameDnsARecordOnLaunch((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(enableResourceNameDnsARecordOnLaunch)).build());
        }

        public Builder enableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue var1);

        default public Builder enableResourceNameDnsAAAARecordOnLaunch(Consumer<AttributeBooleanValue.Builder> enableResourceNameDnsAAAARecordOnLaunch) {
            return this.enableResourceNameDnsAAAARecordOnLaunch((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(enableResourceNameDnsAAAARecordOnLaunch)).build());
        }

        public Builder enableLniAtDeviceIndex(Integer var1);

        public Builder disableLniAtDeviceIndex(AttributeBooleanValue var1);

        default public Builder disableLniAtDeviceIndex(Consumer<AttributeBooleanValue.Builder> disableLniAtDeviceIndex) {
            return this.disableLniAtDeviceIndex((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(disableLniAtDeviceIndex)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

