/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalGatewayRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalGatewayRoute> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(LocalGatewayRoute.getter(LocalGatewayRoute::destinationCidrBlock)).setter(LocalGatewayRoute.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceGroupId").getter(LocalGatewayRoute.getter(LocalGatewayRoute::localGatewayVirtualInterfaceGroupId)).setter(LocalGatewayRoute.setter(Builder::localGatewayVirtualInterfaceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceGroupId").unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(LocalGatewayRoute.getter(LocalGatewayRoute::typeAsString)).setter(LocalGatewayRoute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(LocalGatewayRoute.getter(LocalGatewayRoute::stateAsString)).setter(LocalGatewayRoute.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableId").getter(LocalGatewayRoute.getter(LocalGatewayRoute::localGatewayRouteTableId)).setter(LocalGatewayRoute.setter(Builder::localGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId").unmarshallLocationName("localGatewayRouteTableId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableArn").getter(LocalGatewayRoute.getter(LocalGatewayRoute::localGatewayRouteTableArn)).setter(LocalGatewayRoute.setter(Builder::localGatewayRouteTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableArn").unmarshallLocationName("localGatewayRouteTableArn").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(LocalGatewayRoute.getter(LocalGatewayRoute::ownerId)).setter(LocalGatewayRoute.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, TYPE_FIELD, STATE_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD, OWNER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationCidrBlock;
    private final String localGatewayVirtualInterfaceGroupId;
    private final String type;
    private final String state;
    private final String localGatewayRouteTableId;
    private final String localGatewayRouteTableArn;
    private final String ownerId;

    private LocalGatewayRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.type = builder.type;
        this.state = builder.state;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayRouteTableArn = builder.localGatewayRouteTableArn;
        this.ownerId = builder.ownerId;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String localGatewayVirtualInterfaceGroupId() {
        return this.localGatewayVirtualInterfaceGroupId;
    }

    public final LocalGatewayRouteType type() {
        return LocalGatewayRouteType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final LocalGatewayRouteState state() {
        return LocalGatewayRouteState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }

    public final String localGatewayRouteTableArn() {
        return this.localGatewayRouteTableArn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayRoute)) {
            return false;
        }
        LocalGatewayRoute other = (LocalGatewayRoute)obj;
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.localGatewayRouteTableId(), other.localGatewayRouteTableId()) && Objects.equals(this.localGatewayRouteTableArn(), other.localGatewayRouteTableArn()) && Objects.equals(this.ownerId(), other.ownerId());
    }

    public final String toString() {
        return ToString.builder((String)"LocalGatewayRoute").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("LocalGatewayVirtualInterfaceGroupId", (Object)this.localGatewayVirtualInterfaceGroupId()).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).add("LocalGatewayRouteTableId", (Object)this.localGatewayRouteTableId()).add("LocalGatewayRouteTableArn", (Object)this.localGatewayRouteTableArn()).add("OwnerId", (Object)this.ownerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "LocalGatewayVirtualInterfaceGroupId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceGroupId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "LocalGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableId()));
            }
            case "LocalGatewayRouteTableArn": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableArn()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayRoute, T> g) {
        return obj -> g.apply((LocalGatewayRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String localGatewayVirtualInterfaceGroupId;
        private String type;
        private String state;
        private String localGatewayRouteTableId;
        private String localGatewayRouteTableArn;
        private String ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayRoute model) {
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            this.type(model.type);
            this.state(model.state);
            this.localGatewayRouteTableId(model.localGatewayRouteTableId);
            this.localGatewayRouteTableArn(model.localGatewayRouteTableArn);
            this.ownerId(model.ownerId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        @Transient
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(LocalGatewayRouteType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(LocalGatewayRouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getLocalGatewayRouteTableArn() {
            return this.localGatewayRouteTableArn;
        }

        public final void setLocalGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public LocalGatewayRoute build() {
            return new LocalGatewayRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalGatewayRoute> {
        public Builder destinationCidrBlock(String var1);

        public Builder localGatewayVirtualInterfaceGroupId(String var1);

        public Builder type(String var1);

        public Builder type(LocalGatewayRouteType var1);

        public Builder state(String var1);

        public Builder state(LocalGatewayRouteState var1);

        public Builder localGatewayRouteTableId(String var1);

        public Builder localGatewayRouteTableArn(String var1);

        public Builder ownerId(String var1);
    }
}

