/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpamPoolAllocationResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPoolAllocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPoolAllocation> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(IpamPoolAllocation.getter(IpamPoolAllocation::cidr)).setter(IpamPoolAllocation.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("cidr").build()}).build();
    private static final SdkField<String> IPAM_POOL_ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolAllocationId").getter(IpamPoolAllocation.getter(IpamPoolAllocation::ipamPoolAllocationId)).setter(IpamPoolAllocation.setter(Builder::ipamPoolAllocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolAllocationId").unmarshallLocationName("ipamPoolAllocationId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(IpamPoolAllocation.getter(IpamPoolAllocation::description)).setter(IpamPoolAllocation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(IpamPoolAllocation.getter(IpamPoolAllocation::resourceId)).setter(IpamPoolAllocation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamPoolAllocation.getter(IpamPoolAllocation::resourceTypeAsString)).setter(IpamPoolAllocation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(IpamPoolAllocation.getter(IpamPoolAllocation::resourceRegion)).setter(IpamPoolAllocation.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("resourceRegion").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwner").getter(IpamPoolAllocation.getter(IpamPoolAllocation::resourceOwner)).setter(IpamPoolAllocation.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").unmarshallLocationName("resourceOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, IPAM_POOL_ALLOCATION_ID_FIELD, DESCRIPTION_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_REGION_FIELD, RESOURCE_OWNER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidr;
    private final String ipamPoolAllocationId;
    private final String description;
    private final String resourceId;
    private final String resourceType;
    private final String resourceRegion;
    private final String resourceOwner;

    private IpamPoolAllocation(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.ipamPoolAllocationId = builder.ipamPoolAllocationId;
        this.description = builder.description;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceRegion = builder.resourceRegion;
        this.resourceOwner = builder.resourceOwner;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String ipamPoolAllocationId() {
        return this.ipamPoolAllocationId;
    }

    public final String description() {
        return this.description;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final IpamPoolAllocationResourceType resourceType() {
        return IpamPoolAllocationResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final String resourceOwner() {
        return this.resourceOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolAllocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPoolAllocation)) {
            return false;
        }
        IpamPoolAllocation other = (IpamPoolAllocation)obj;
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.ipamPoolAllocationId(), other.ipamPoolAllocationId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.resourceOwner(), other.resourceOwner());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPoolAllocation").add("Cidr", (Object)this.cidr()).add("IpamPoolAllocationId", (Object)this.ipamPoolAllocationId()).add("Description", (Object)this.description()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceRegion", (Object)this.resourceRegion()).add("ResourceOwner", (Object)this.resourceOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "IpamPoolAllocationId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolAllocationId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamPoolAllocation, T> g) {
        return obj -> g.apply((IpamPoolAllocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidr;
        private String ipamPoolAllocationId;
        private String description;
        private String resourceId;
        private String resourceType;
        private String resourceRegion;
        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPoolAllocation model) {
            this.cidr(model.cidr);
            this.ipamPoolAllocationId(model.ipamPoolAllocationId);
            this.description(model.description);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceRegion(model.resourceRegion);
            this.resourceOwner(model.resourceOwner);
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        @Transient
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpamPoolAllocationId() {
            return this.ipamPoolAllocationId;
        }

        public final void setIpamPoolAllocationId(String ipamPoolAllocationId) {
            this.ipamPoolAllocationId = ipamPoolAllocationId;
        }

        @Override
        @Transient
        public final Builder ipamPoolAllocationId(String ipamPoolAllocationId) {
            this.ipamPoolAllocationId = ipamPoolAllocationId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(IpamPoolAllocationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        @Transient
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        @Transient
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public IpamPoolAllocation build() {
            return new IpamPoolAllocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPoolAllocation> {
        public Builder cidr(String var1);

        public Builder ipamPoolAllocationId(String var1);

        public Builder description(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamPoolAllocationResourceType var1);

        public Builder resourceRegion(String var1);

        public Builder resourceOwner(String var1);
    }
}

