/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageAttributeName {
    DESCRIPTION("description"),
    KERNEL("kernel"),
    RAMDISK("ramdisk"),
    LAUNCH_PERMISSION("launchPermission"),
    PRODUCT_CODES("productCodes"),
    BLOCK_DEVICE_MAPPING("blockDeviceMapping"),
    SRIOV_NET_SUPPORT("sriovNetSupport"),
    BOOT_MODE("bootMode"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageAttributeName> VALUE_MAP;
    private final String value;

    private ImageAttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageAttributeName> knownValues() {
        EnumSet<ImageAttributeName> knownValues = EnumSet.allOf(ImageAttributeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageAttributeName.class, ImageAttributeName::toString);
    }
}

