/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysisListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInsightsAnalysesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeNetworkInsightsAnalysesResponse> {
    private static final SdkField<List<NetworkInsightsAnalysis>> NETWORK_INSIGHTS_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInsightsAnalyses").getter(DescribeNetworkInsightsAnalysesResponse.getter(DescribeNetworkInsightsAnalysesResponse::networkInsightsAnalyses)).setter(DescribeNetworkInsightsAnalysesResponse.setter(Builder::networkInsightsAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAnalysisSet").unmarshallLocationName("networkInsightsAnalysisSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInsightsAnalysis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNetworkInsightsAnalysesResponse.getter(DescribeNetworkInsightsAnalysesResponse::nextToken)).setter(DescribeNetworkInsightsAnalysesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ANALYSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<NetworkInsightsAnalysis> networkInsightsAnalyses;
    private final String nextToken;

    private DescribeNetworkInsightsAnalysesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAnalyses = builder.networkInsightsAnalyses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkInsightsAnalyses() {
        return this.networkInsightsAnalyses != null && !(this.networkInsightsAnalyses instanceof SdkAutoConstructList);
    }

    public final List<NetworkInsightsAnalysis> networkInsightsAnalyses() {
        return this.networkInsightsAnalyses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInsightsAnalyses() ? this.networkInsightsAnalyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInsightsAnalysesResponse)) {
            return false;
        }
        DescribeNetworkInsightsAnalysesResponse other = (DescribeNetworkInsightsAnalysesResponse)((Object)obj);
        return this.hasNetworkInsightsAnalyses() == other.hasNetworkInsightsAnalyses() && Objects.equals(this.networkInsightsAnalyses(), other.networkInsightsAnalyses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNetworkInsightsAnalysesResponse").add("NetworkInsightsAnalyses", this.hasNetworkInsightsAnalyses() ? this.networkInsightsAnalyses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAnalyses": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAnalyses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInsightsAnalysesResponse, T> g) {
        return obj -> g.apply((DescribeNetworkInsightsAnalysesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<NetworkInsightsAnalysis> networkInsightsAnalyses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInsightsAnalysesResponse model) {
            super(model);
            this.networkInsightsAnalyses(model.networkInsightsAnalyses);
            this.nextToken(model.nextToken);
        }

        public final List<NetworkInsightsAnalysis.Builder> getNetworkInsightsAnalyses() {
            List<NetworkInsightsAnalysis.Builder> result = NetworkInsightsAnalysisListCopier.copyToBuilder(this.networkInsightsAnalyses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInsightsAnalyses(Collection<NetworkInsightsAnalysis.BuilderImpl> networkInsightsAnalyses) {
            this.networkInsightsAnalyses = NetworkInsightsAnalysisListCopier.copyFromBuilder(networkInsightsAnalyses);
        }

        @Override
        @Transient
        public final Builder networkInsightsAnalyses(Collection<NetworkInsightsAnalysis> networkInsightsAnalyses) {
            this.networkInsightsAnalyses = NetworkInsightsAnalysisListCopier.copy(networkInsightsAnalyses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInsightsAnalyses(NetworkInsightsAnalysis ... networkInsightsAnalyses) {
            this.networkInsightsAnalyses(Arrays.asList(networkInsightsAnalyses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInsightsAnalyses(Consumer<NetworkInsightsAnalysis.Builder> ... networkInsightsAnalyses) {
            this.networkInsightsAnalyses(Stream.of(networkInsightsAnalyses).map(c -> (NetworkInsightsAnalysis)((NetworkInsightsAnalysis.Builder)NetworkInsightsAnalysis.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeNetworkInsightsAnalysesResponse build() {
            return new DescribeNetworkInsightsAnalysesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInsightsAnalysesResponse> {
        public Builder networkInsightsAnalyses(Collection<NetworkInsightsAnalysis> var1);

        public Builder networkInsightsAnalyses(NetworkInsightsAnalysis ... var1);

        public Builder networkInsightsAnalyses(Consumer<NetworkInsightsAnalysis.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

