/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.VirtualGateway;
import software.amazon.awssdk.services.directconnect.model.VirtualGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVirtualGatewaysResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeVirtualGatewaysResponse> {
    private static final SdkField<List<VirtualGateway>> VIRTUAL_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("virtualGateways").getter(DescribeVirtualGatewaysResponse.getter(DescribeVirtualGatewaysResponse::virtualGateways)).setter(DescribeVirtualGatewaysResponse.setter(Builder::virtualGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_GATEWAYS_FIELD));
    private final List<VirtualGateway> virtualGateways;

    private DescribeVirtualGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.virtualGateways = builder.virtualGateways;
    }

    public final boolean hasVirtualGateways() {
        return this.virtualGateways != null && !(this.virtualGateways instanceof SdkAutoConstructList);
    }

    public final List<VirtualGateway> virtualGateways() {
        return this.virtualGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualGateways() ? this.virtualGateways() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualGatewaysResponse)) {
            return false;
        }
        DescribeVirtualGatewaysResponse other = (DescribeVirtualGatewaysResponse)((Object)obj);
        return this.hasVirtualGateways() == other.hasVirtualGateways() && Objects.equals(this.virtualGateways(), other.virtualGateways());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVirtualGatewaysResponse").add("VirtualGateways", this.hasVirtualGateways() ? this.virtualGateways() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualGateways": {
                return Optional.ofNullable(clazz.cast(this.virtualGateways()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeVirtualGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<VirtualGateway> virtualGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualGatewaysResponse model) {
            super(model);
            this.virtualGateways(model.virtualGateways);
        }

        public final List<VirtualGateway.Builder> getVirtualGateways() {
            List<VirtualGateway.Builder> result = VirtualGatewayListCopier.copyToBuilder(this.virtualGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder virtualGateways(Collection<VirtualGateway> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copy(virtualGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(VirtualGateway ... virtualGateways) {
            this.virtualGateways(Arrays.asList(virtualGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(Consumer<VirtualGateway.Builder> ... virtualGateways) {
            this.virtualGateways(Stream.of(virtualGateways).map(c -> (VirtualGateway)((VirtualGateway.Builder)VirtualGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualGateways(Collection<VirtualGateway.BuilderImpl> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copyFromBuilder(virtualGateways);
        }

        @Override
        public DescribeVirtualGatewaysResponse build() {
            return new DescribeVirtualGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVirtualGatewaysResponse> {
        public Builder virtualGateways(Collection<VirtualGateway> var1);

        public Builder virtualGateways(VirtualGateway ... var1);

        public Builder virtualGateways(Consumer<VirtualGateway.Builder> ... var1);
    }
}

