/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClient;
import software.amazon.awssdk.services.dataexchange.model.AssetEntry;
import software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse;

public class ListRevisionAssetsPublisher
implements SdkPublisher<ListRevisionAssetsResponse> {
    private final DataExchangeAsyncClient client;
    private final ListRevisionAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRevisionAssetsPublisher(DataExchangeAsyncClient client, ListRevisionAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRevisionAssetsPublisher(DataExchangeAsyncClient client, ListRevisionAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRevisionAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRevisionAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetEntry> assets() {
        Function<ListRevisionAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assets() != null) {
                return response.assets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRevisionAssetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRevisionAssetsResponseFetcher
    implements AsyncPageFetcher<ListRevisionAssetsResponse> {
        private ListRevisionAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListRevisionAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRevisionAssetsResponse> nextPage(ListRevisionAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListRevisionAssetsPublisher.this.client.listRevisionAssets(ListRevisionAssetsPublisher.this.firstRequest);
            }
            return ListRevisionAssetsPublisher.this.client.listRevisionAssets((ListRevisionAssetsRequest)((Object)ListRevisionAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

