/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.AssetDestinationEntry;
import software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption;
import software.amazon.awssdk.services.dataexchange.model.ListOfAssetDestinationEntryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportAssetsToS3ResponseDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportAssetsToS3ResponseDetails> {
    private static final SdkField<List<AssetDestinationEntry>> ASSET_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssetDestinations").getter(ExportAssetsToS3ResponseDetails.getter(ExportAssetsToS3ResponseDetails::assetDestinations)).setter(ExportAssetsToS3ResponseDetails.setter(Builder::assetDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetDestinationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(ExportAssetsToS3ResponseDetails.getter(ExportAssetsToS3ResponseDetails::dataSetId)).setter(ExportAssetsToS3ResponseDetails.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<ExportServerSideEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(ExportAssetsToS3ResponseDetails.getter(ExportAssetsToS3ResponseDetails::encryption)).setter(ExportAssetsToS3ResponseDetails.setter(Builder::encryption)).constructor(ExportServerSideEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(ExportAssetsToS3ResponseDetails.getter(ExportAssetsToS3ResponseDetails::revisionId)).setter(ExportAssetsToS3ResponseDetails.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_DESTINATIONS_FIELD, DATA_SET_ID_FIELD, ENCRYPTION_FIELD, REVISION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AssetDestinationEntry> assetDestinations;
    private final String dataSetId;
    private final ExportServerSideEncryption encryption;
    private final String revisionId;

    private ExportAssetsToS3ResponseDetails(BuilderImpl builder) {
        this.assetDestinations = builder.assetDestinations;
        this.dataSetId = builder.dataSetId;
        this.encryption = builder.encryption;
        this.revisionId = builder.revisionId;
    }

    public final boolean hasAssetDestinations() {
        return this.assetDestinations != null && !(this.assetDestinations instanceof SdkAutoConstructList);
    }

    public final List<AssetDestinationEntry> assetDestinations() {
        return this.assetDestinations;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final ExportServerSideEncryption encryption() {
        return this.encryption;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetDestinations() ? this.assetDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAssetsToS3ResponseDetails)) {
            return false;
        }
        ExportAssetsToS3ResponseDetails other = (ExportAssetsToS3ResponseDetails)obj;
        return this.hasAssetDestinations() == other.hasAssetDestinations() && Objects.equals(this.assetDestinations(), other.assetDestinations()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"ExportAssetsToS3ResponseDetails").add("AssetDestinations", this.hasAssetDestinations() ? this.assetDestinations() : null).add("DataSetId", (Object)this.dataSetId()).add("Encryption", (Object)this.encryption()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetDestinations": {
                return Optional.ofNullable(clazz.cast(this.assetDestinations()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportAssetsToS3ResponseDetails, T> g) {
        return obj -> g.apply((ExportAssetsToS3ResponseDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AssetDestinationEntry> assetDestinations = DefaultSdkAutoConstructList.getInstance();
        private String dataSetId;
        private ExportServerSideEncryption encryption;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAssetsToS3ResponseDetails model) {
            this.assetDestinations(model.assetDestinations);
            this.dataSetId(model.dataSetId);
            this.encryption(model.encryption);
            this.revisionId(model.revisionId);
        }

        public final List<AssetDestinationEntry.Builder> getAssetDestinations() {
            List<AssetDestinationEntry.Builder> result = ListOfAssetDestinationEntryCopier.copyToBuilder(this.assetDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder assetDestinations(Collection<AssetDestinationEntry> assetDestinations) {
            this.assetDestinations = ListOfAssetDestinationEntryCopier.copy(assetDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetDestinations(AssetDestinationEntry ... assetDestinations) {
            this.assetDestinations(Arrays.asList(assetDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetDestinations(Consumer<AssetDestinationEntry.Builder> ... assetDestinations) {
            this.assetDestinations(Stream.of(assetDestinations).map(c -> (AssetDestinationEntry)((AssetDestinationEntry.Builder)AssetDestinationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetDestinations(Collection<AssetDestinationEntry.BuilderImpl> assetDestinations) {
            this.assetDestinations = ListOfAssetDestinationEntryCopier.copyFromBuilder(assetDestinations);
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final ExportServerSideEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(ExportServerSideEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(ExportServerSideEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public ExportAssetsToS3ResponseDetails build() {
            return new ExportAssetsToS3ResponseDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportAssetsToS3ResponseDetails> {
        public Builder assetDestinations(Collection<AssetDestinationEntry> var1);

        public Builder assetDestinations(AssetDestinationEntry ... var1);

        public Builder assetDestinations(Consumer<AssetDestinationEntry.Builder> ... var1);

        public Builder dataSetId(String var1);

        public Builder encryption(ExportServerSideEncryption var1);

        default public Builder encryption(Consumer<ExportServerSideEncryption.Builder> encryption) {
            return this.encryption((ExportServerSideEncryption)((ExportServerSideEncryption.Builder)ExportServerSideEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder revisionId(String var1);
    }
}

