/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MigrationTypeValue {
    FULL_LOAD("full-load"),
    CDC("cdc"),
    FULL_LOAD_AND_CDC("full-load-and-cdc"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MigrationTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MigrationTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MigrationTypeValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MigrationTypeValue> knownValues() {
        return Stream.of(MigrationTypeValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

