/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthTypeValue {
    NO("no"),
    PASSWORD("password"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthTypeValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthTypeValue> knownValues() {
        return Stream.of(AuthTypeValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

