/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about types of supported endpoints in response to a request by the
 * <code>DescribeEndpointTypes</code> operation. This information includes the type of endpoint, the database engine
 * name, and whether change data capture (CDC) is supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedEndpointType implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedEndpointType.Builder, SupportedEndpointType> {
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineName").getter(getter(SupportedEndpointType::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<Boolean> SUPPORTS_CDC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsCDC").getter(getter(SupportedEndpointType::supportsCDC)).setter(setter(Builder::supportsCDC))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsCDC").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(SupportedEndpointType::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_ENGINE_MINIMUM_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceEngineMinimumVersion")
            .getter(getter(SupportedEndpointType::replicationInstanceEngineMinimumVersion))
            .setter(setter(Builder::replicationInstanceEngineMinimumVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationInstanceEngineMinimumVersion").build()).build();

    private static final SdkField<String> ENGINE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineDisplayName").getter(getter(SupportedEndpointType::engineDisplayName))
            .setter(setter(Builder::engineDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineDisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENGINE_NAME_FIELD, SUPPORTS_CDC_FIELD, ENDPOINT_TYPE_FIELD,
                    REPLICATION_INSTANCE_ENGINE_MINIMUM_VERSION_FIELD, ENGINE_DISPLAY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engineName;

    private final Boolean supportsCDC;

    private final String endpointType;

    private final String replicationInstanceEngineMinimumVersion;

    private final String engineDisplayName;

    private SupportedEndpointType(BuilderImpl builder) {
        this.engineName = builder.engineName;
        this.supportsCDC = builder.supportsCDC;
        this.endpointType = builder.endpointType;
        this.replicationInstanceEngineMinimumVersion = builder.replicationInstanceEngineMinimumVersion;
        this.engineDisplayName = builder.engineDisplayName;
    }

    /**
     * <p>
     * The database engine name. Valid values, depending on the EndpointType, include <code>"mysql"</code>,
     * <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
     * <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>,
     * <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
     * <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>,
     * <code>"sqlserver"</code>, and <code>"neptune"</code>.
     * </p>
     * 
     * @return The database engine name. Valid values, depending on the EndpointType, include <code>"mysql"</code>,
     *         <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
     *         <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>,
     *         <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
     *         <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>,
     *         <code>"sqlserver"</code>, and <code>"neptune"</code>.
     */
    public final String engineName() {
        return engineName;
    }

    /**
     * <p>
     * Indicates if Change Data Capture (CDC) is supported.
     * </p>
     * 
     * @return Indicates if Change Data Capture (CDC) is supported.
     */
    public final Boolean supportsCDC() {
        return supportsCDC;
    }

    /**
     * <p>
     * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ReplicationEndpointTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * @see ReplicationEndpointTypeValue
     */
    public final ReplicationEndpointTypeValue endpointType() {
        return ReplicationEndpointTypeValue.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ReplicationEndpointTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * @see ReplicationEndpointTypeValue
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The earliest AWS DMS engine version that supports this endpoint engine. Note that endpoint engines released with
     * AWS DMS versions earlier than 3.1.1 do not return a value for this parameter.
     * </p>
     * 
     * @return The earliest AWS DMS engine version that supports this endpoint engine. Note that endpoint engines
     *         released with AWS DMS versions earlier than 3.1.1 do not return a value for this parameter.
     */
    public final String replicationInstanceEngineMinimumVersion() {
        return replicationInstanceEngineMinimumVersion;
    }

    /**
     * <p>
     * The expanded name for the engine name. For example, if the <code>EngineName</code> parameter is "aurora," this
     * value would be "Amazon Aurora MySQL."
     * </p>
     * 
     * @return The expanded name for the engine name. For example, if the <code>EngineName</code> parameter is "aurora,"
     *         this value would be "Amazon Aurora MySQL."
     */
    public final String engineDisplayName() {
        return engineDisplayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(supportsCDC());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceEngineMinimumVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineDisplayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedEndpointType)) {
            return false;
        }
        SupportedEndpointType other = (SupportedEndpointType) obj;
        return Objects.equals(engineName(), other.engineName()) && Objects.equals(supportsCDC(), other.supportsCDC())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(replicationInstanceEngineMinimumVersion(), other.replicationInstanceEngineMinimumVersion())
                && Objects.equals(engineDisplayName(), other.engineDisplayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedEndpointType").add("EngineName", engineName()).add("SupportsCDC", supportsCDC())
                .add("EndpointType", endpointTypeAsString())
                .add("ReplicationInstanceEngineMinimumVersion", replicationInstanceEngineMinimumVersion())
                .add("EngineDisplayName", engineDisplayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "SupportsCDC":
            return Optional.ofNullable(clazz.cast(supportsCDC()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "ReplicationInstanceEngineMinimumVersion":
            return Optional.ofNullable(clazz.cast(replicationInstanceEngineMinimumVersion()));
        case "EngineDisplayName":
            return Optional.ofNullable(clazz.cast(engineDisplayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SupportedEndpointType, T> g) {
        return obj -> g.apply((SupportedEndpointType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedEndpointType> {
        /**
         * <p>
         * The database engine name. Valid values, depending on the EndpointType, include <code>"mysql"</code>,
         * <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
         * <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>,
         * <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
         * <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>,
         * <code>"sqlserver"</code>, and <code>"neptune"</code>.
         * </p>
         * 
         * @param engineName
         *        The database engine name. Valid values, depending on the EndpointType, include <code>"mysql"</code>,
         *        <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
         *        <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>,
         *        <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
         *        <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>,
         *        <code>"sqlserver"</code>, and <code>"neptune"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * Indicates if Change Data Capture (CDC) is supported.
         * </p>
         * 
         * @param supportsCDC
         *        Indicates if Change Data Capture (CDC) is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsCDC(Boolean supportsCDC);

        /**
         * <p>
         * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * @see ReplicationEndpointTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationEndpointTypeValue
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * @see ReplicationEndpointTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationEndpointTypeValue
         */
        Builder endpointType(ReplicationEndpointTypeValue endpointType);

        /**
         * <p>
         * The earliest AWS DMS engine version that supports this endpoint engine. Note that endpoint engines released
         * with AWS DMS versions earlier than 3.1.1 do not return a value for this parameter.
         * </p>
         * 
         * @param replicationInstanceEngineMinimumVersion
         *        The earliest AWS DMS engine version that supports this endpoint engine. Note that endpoint engines
         *        released with AWS DMS versions earlier than 3.1.1 do not return a value for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceEngineMinimumVersion(String replicationInstanceEngineMinimumVersion);

        /**
         * <p>
         * The expanded name for the engine name. For example, if the <code>EngineName</code> parameter is "aurora,"
         * this value would be "Amazon Aurora MySQL."
         * </p>
         * 
         * @param engineDisplayName
         *        The expanded name for the engine name. For example, if the <code>EngineName</code> parameter is
         *        "aurora," this value would be "Amazon Aurora MySQL."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineDisplayName(String engineDisplayName);
    }

    static final class BuilderImpl implements Builder {
        private String engineName;

        private Boolean supportsCDC;

        private String endpointType;

        private String replicationInstanceEngineMinimumVersion;

        private String engineDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedEndpointType model) {
            engineName(model.engineName);
            supportsCDC(model.supportsCDC);
            endpointType(model.endpointType);
            replicationInstanceEngineMinimumVersion(model.replicationInstanceEngineMinimumVersion);
            engineDisplayName(model.engineDisplayName);
        }

        public final String getEngineName() {
            return engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final Boolean getSupportsCDC() {
            return supportsCDC;
        }

        @Override
        public final Builder supportsCDC(Boolean supportsCDC) {
            this.supportsCDC = supportsCDC;
            return this;
        }

        public final void setSupportsCDC(Boolean supportsCDC) {
            this.supportsCDC = supportsCDC;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ReplicationEndpointTypeValue endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getReplicationInstanceEngineMinimumVersion() {
            return replicationInstanceEngineMinimumVersion;
        }

        @Override
        public final Builder replicationInstanceEngineMinimumVersion(String replicationInstanceEngineMinimumVersion) {
            this.replicationInstanceEngineMinimumVersion = replicationInstanceEngineMinimumVersion;
            return this;
        }

        public final void setReplicationInstanceEngineMinimumVersion(String replicationInstanceEngineMinimumVersion) {
            this.replicationInstanceEngineMinimumVersion = replicationInstanceEngineMinimumVersion;
        }

        public final String getEngineDisplayName() {
            return engineDisplayName;
        }

        @Override
        public final Builder engineDisplayName(String engineDisplayName) {
            this.engineDisplayName = engineDisplayName;
            return this;
        }

        public final void setEngineDisplayName(String engineDisplayName) {
            this.engineDisplayName = engineDisplayName;
        }

        @Override
        public SupportedEndpointType build() {
            return new SupportedEndpointType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
