/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The task assessment report in JSON format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationTaskAssessmentResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationTaskAssessmentResult.Builder, ReplicationTaskAssessmentResult> {
    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskIdentifier").getter(getter(ReplicationTaskAssessmentResult::replicationTaskIdentifier))
            .setter(setter(Builder::replicationTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build())
            .build();

    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskArn").getter(getter(ReplicationTaskAssessmentResult::replicationTaskArn))
            .setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<Instant> REPLICATION_TASK_LAST_ASSESSMENT_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplicationTaskLastAssessmentDate")
            .getter(getter(ReplicationTaskAssessmentResult::replicationTaskLastAssessmentDate))
            .setter(setter(Builder::replicationTaskLastAssessmentDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskLastAssessmentDate")
                    .build()).build();

    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssessmentStatus").getter(getter(ReplicationTaskAssessmentResult::assessmentStatus))
            .setter(setter(Builder::assessmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentStatus").build()).build();

    private static final SdkField<String> ASSESSMENT_RESULTS_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssessmentResultsFile").getter(getter(ReplicationTaskAssessmentResult::assessmentResultsFile))
            .setter(setter(Builder::assessmentResultsFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentResultsFile").build())
            .build();

    private static final SdkField<String> ASSESSMENT_RESULTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssessmentResults").getter(getter(ReplicationTaskAssessmentResult::assessmentResults))
            .setter(setter(Builder::assessmentResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentResults").build()).build();

    private static final SdkField<String> S3_OBJECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ObjectUrl").getter(getter(ReplicationTaskAssessmentResult::s3ObjectUrl))
            .setter(setter(Builder::s3ObjectUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_TASK_IDENTIFIER_FIELD, REPLICATION_TASK_ARN_FIELD, REPLICATION_TASK_LAST_ASSESSMENT_DATE_FIELD,
            ASSESSMENT_STATUS_FIELD, ASSESSMENT_RESULTS_FILE_FIELD, ASSESSMENT_RESULTS_FIELD, S3_OBJECT_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationTaskIdentifier;

    private final String replicationTaskArn;

    private final Instant replicationTaskLastAssessmentDate;

    private final String assessmentStatus;

    private final String assessmentResultsFile;

    private final String assessmentResults;

    private final String s3ObjectUrl;

    private ReplicationTaskAssessmentResult(BuilderImpl builder) {
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationTaskLastAssessmentDate = builder.replicationTaskLastAssessmentDate;
        this.assessmentStatus = builder.assessmentStatus;
        this.assessmentResultsFile = builder.assessmentResultsFile;
        this.assessmentResults = builder.assessmentResults;
        this.s3ObjectUrl = builder.s3ObjectUrl;
    }

    /**
     * <p>
     * The replication task identifier of the task on which the task assessment was run.
     * </p>
     * 
     * @return The replication task identifier of the task on which the task assessment was run.
     */
    public final String replicationTaskIdentifier() {
        return replicationTaskIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication task.
     */
    public final String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * The date the task assessment was completed.
     * </p>
     * 
     * @return The date the task assessment was completed.
     */
    public final Instant replicationTaskLastAssessmentDate() {
        return replicationTaskLastAssessmentDate;
    }

    /**
     * <p>
     * The status of the task assessment.
     * </p>
     * 
     * @return The status of the task assessment.
     */
    public final String assessmentStatus() {
        return assessmentStatus;
    }

    /**
     * <p>
     * The file containing the results of the task assessment.
     * </p>
     * 
     * @return The file containing the results of the task assessment.
     */
    public final String assessmentResultsFile() {
        return assessmentResultsFile;
    }

    /**
     * <p>
     * The task assessment results in JSON format.
     * </p>
     * 
     * @return The task assessment results in JSON format.
     */
    public final String assessmentResults() {
        return assessmentResults;
    }

    /**
     * <p>
     * The URL of the S3 object containing the task assessment results.
     * </p>
     * 
     * @return The URL of the S3 object containing the task assessment results.
     */
    public final String s3ObjectUrl() {
        return s3ObjectUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskLastAssessmentDate());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentResultsFile());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentResults());
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskAssessmentResult)) {
            return false;
        }
        ReplicationTaskAssessmentResult other = (ReplicationTaskAssessmentResult) obj;
        return Objects.equals(replicationTaskIdentifier(), other.replicationTaskIdentifier())
                && Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(replicationTaskLastAssessmentDate(), other.replicationTaskLastAssessmentDate())
                && Objects.equals(assessmentStatus(), other.assessmentStatus())
                && Objects.equals(assessmentResultsFile(), other.assessmentResultsFile())
                && Objects.equals(assessmentResults(), other.assessmentResults())
                && Objects.equals(s3ObjectUrl(), other.s3ObjectUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationTaskAssessmentResult").add("ReplicationTaskIdentifier", replicationTaskIdentifier())
                .add("ReplicationTaskArn", replicationTaskArn())
                .add("ReplicationTaskLastAssessmentDate", replicationTaskLastAssessmentDate())
                .add("AssessmentStatus", assessmentStatus()).add("AssessmentResultsFile", assessmentResultsFile())
                .add("AssessmentResults", assessmentResults()).add("S3ObjectUrl", s3ObjectUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskIdentifier":
            return Optional.ofNullable(clazz.cast(replicationTaskIdentifier()));
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "ReplicationTaskLastAssessmentDate":
            return Optional.ofNullable(clazz.cast(replicationTaskLastAssessmentDate()));
        case "AssessmentStatus":
            return Optional.ofNullable(clazz.cast(assessmentStatus()));
        case "AssessmentResultsFile":
            return Optional.ofNullable(clazz.cast(assessmentResultsFile()));
        case "AssessmentResults":
            return Optional.ofNullable(clazz.cast(assessmentResults()));
        case "S3ObjectUrl":
            return Optional.ofNullable(clazz.cast(s3ObjectUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskAssessmentResult, T> g) {
        return obj -> g.apply((ReplicationTaskAssessmentResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationTaskAssessmentResult> {
        /**
         * <p>
         * The replication task identifier of the task on which the task assessment was run.
         * </p>
         * 
         * @param replicationTaskIdentifier
         *        The replication task identifier of the task on which the task assessment was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIdentifier(String replicationTaskIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication task.
         * </p>
         * 
         * @param replicationTaskArn
         *        The Amazon Resource Name (ARN) of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * The date the task assessment was completed.
         * </p>
         * 
         * @param replicationTaskLastAssessmentDate
         *        The date the task assessment was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskLastAssessmentDate(Instant replicationTaskLastAssessmentDate);

        /**
         * <p>
         * The status of the task assessment.
         * </p>
         * 
         * @param assessmentStatus
         *        The status of the task assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentStatus(String assessmentStatus);

        /**
         * <p>
         * The file containing the results of the task assessment.
         * </p>
         * 
         * @param assessmentResultsFile
         *        The file containing the results of the task assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentResultsFile(String assessmentResultsFile);

        /**
         * <p>
         * The task assessment results in JSON format.
         * </p>
         * 
         * @param assessmentResults
         *        The task assessment results in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentResults(String assessmentResults);

        /**
         * <p>
         * The URL of the S3 object containing the task assessment results.
         * </p>
         * 
         * @param s3ObjectUrl
         *        The URL of the S3 object containing the task assessment results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectUrl(String s3ObjectUrl);
    }

    static final class BuilderImpl implements Builder {
        private String replicationTaskIdentifier;

        private String replicationTaskArn;

        private Instant replicationTaskLastAssessmentDate;

        private String assessmentStatus;

        private String assessmentResultsFile;

        private String assessmentResults;

        private String s3ObjectUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskAssessmentResult model) {
            replicationTaskIdentifier(model.replicationTaskIdentifier);
            replicationTaskArn(model.replicationTaskArn);
            replicationTaskLastAssessmentDate(model.replicationTaskLastAssessmentDate);
            assessmentStatus(model.assessmentStatus);
            assessmentResultsFile(model.assessmentResultsFile);
            assessmentResults(model.assessmentResults);
            s3ObjectUrl(model.s3ObjectUrl);
        }

        public final String getReplicationTaskIdentifier() {
            return replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final Instant getReplicationTaskLastAssessmentDate() {
            return replicationTaskLastAssessmentDate;
        }

        @Override
        public final Builder replicationTaskLastAssessmentDate(Instant replicationTaskLastAssessmentDate) {
            this.replicationTaskLastAssessmentDate = replicationTaskLastAssessmentDate;
            return this;
        }

        public final void setReplicationTaskLastAssessmentDate(Instant replicationTaskLastAssessmentDate) {
            this.replicationTaskLastAssessmentDate = replicationTaskLastAssessmentDate;
        }

        public final String getAssessmentStatus() {
            return assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        public final String getAssessmentResultsFile() {
            return assessmentResultsFile;
        }

        @Override
        public final Builder assessmentResultsFile(String assessmentResultsFile) {
            this.assessmentResultsFile = assessmentResultsFile;
            return this;
        }

        public final void setAssessmentResultsFile(String assessmentResultsFile) {
            this.assessmentResultsFile = assessmentResultsFile;
        }

        public final String getAssessmentResults() {
            return assessmentResults;
        }

        @Override
        public final Builder assessmentResults(String assessmentResults) {
            this.assessmentResults = assessmentResults;
            return this;
        }

        public final void setAssessmentResults(String assessmentResults) {
            this.assessmentResults = assessmentResults;
        }

        public final String getS3ObjectUrl() {
            return s3ObjectUrl;
        }

        @Override
        public final Builder s3ObjectUrl(String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
            return this;
        }

        public final void setS3ObjectUrl(String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
        }

        @Override
        public ReplicationTaskAssessmentResult build() {
            return new ReplicationTaskAssessmentResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
