/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationSubnetGroupsResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeReplicationSubnetGroupsResponse.Builder, DescribeReplicationSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationSubnetGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReplicationSubnetGroup>> REPLICATION_SUBNET_GROUPS_FIELD = SdkField
            .<List<ReplicationSubnetGroup>> builder(MarshallingType.LIST)
            .memberName("ReplicationSubnetGroups")
            .getter(getter(DescribeReplicationSubnetGroupsResponse::replicationSubnetGroups))
            .setter(setter(Builder::replicationSubnetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationSubnetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationSubnetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            REPLICATION_SUBNET_GROUPS_FIELD));

    private final String marker;

    private final List<ReplicationSubnetGroup> replicationSubnetGroups;

    private DescribeReplicationSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationSubnetGroups = builder.replicationSubnetGroups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the ReplicationSubnetGroups property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReplicationSubnetGroups() {
        return replicationSubnetGroups != null && !(replicationSubnetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A description of the replication subnet groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationSubnetGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A description of the replication subnet groups.
     */
    public final List<ReplicationSubnetGroup> replicationSubnetGroups() {
        return replicationSubnetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationSubnetGroups() ? replicationSubnetGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationSubnetGroupsResponse)) {
            return false;
        }
        DescribeReplicationSubnetGroupsResponse other = (DescribeReplicationSubnetGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasReplicationSubnetGroups() == other.hasReplicationSubnetGroups()
                && Objects.equals(replicationSubnetGroups(), other.replicationSubnetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicationSubnetGroupsResponse").add("Marker", marker())
                .add("ReplicationSubnetGroups", hasReplicationSubnetGroups() ? replicationSubnetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReplicationSubnetGroups":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationSubnetGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationSubnetGroupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A description of the replication subnet groups.
         * </p>
         * 
         * @param replicationSubnetGroups
         *        A description of the replication subnet groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroups(Collection<ReplicationSubnetGroup> replicationSubnetGroups);

        /**
         * <p>
         * A description of the replication subnet groups.
         * </p>
         * 
         * @param replicationSubnetGroups
         *        A description of the replication subnet groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroups(ReplicationSubnetGroup... replicationSubnetGroups);

        /**
         * <p>
         * A description of the replication subnet groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationSubnetGroup>.Builder} avoiding
         * the need to create one manually via {@link List<ReplicationSubnetGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationSubnetGroup>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationSubnetGroups(List<ReplicationSubnetGroup>)}.
         * 
         * @param replicationSubnetGroups
         *        a consumer that will call methods on {@link List<ReplicationSubnetGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationSubnetGroups(List<ReplicationSubnetGroup>)
         */
        Builder replicationSubnetGroups(Consumer<ReplicationSubnetGroup.Builder>... replicationSubnetGroups);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReplicationSubnetGroup> replicationSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationSubnetGroupsResponse model) {
            super(model);
            marker(model.marker);
            replicationSubnetGroups(model.replicationSubnetGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<ReplicationSubnetGroup.Builder> getReplicationSubnetGroups() {
            List<ReplicationSubnetGroup.Builder> result = ReplicationSubnetGroupsCopier
                    .copyToBuilder(this.replicationSubnetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicationSubnetGroups(Collection<ReplicationSubnetGroup> replicationSubnetGroups) {
            this.replicationSubnetGroups = ReplicationSubnetGroupsCopier.copy(replicationSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationSubnetGroups(ReplicationSubnetGroup... replicationSubnetGroups) {
            replicationSubnetGroups(Arrays.asList(replicationSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationSubnetGroups(Consumer<ReplicationSubnetGroup.Builder>... replicationSubnetGroups) {
            replicationSubnetGroups(Stream.of(replicationSubnetGroups)
                    .map(c -> ReplicationSubnetGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationSubnetGroups(Collection<ReplicationSubnetGroup.BuilderImpl> replicationSubnetGroups) {
            this.replicationSubnetGroups = ReplicationSubnetGroupsCopier.copyFromBuilder(replicationSubnetGroups);
        }

        @Override
        public DescribeReplicationSubnetGroupsResponse build() {
            return new DescribeReplicationSubnetGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
