/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationInstancesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeReplicationInstancesResponse.Builder, DescribeReplicationInstancesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationInstancesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReplicationInstance>> REPLICATION_INSTANCES_FIELD = SdkField
            .<List<ReplicationInstance>> builder(MarshallingType.LIST)
            .memberName("ReplicationInstances")
            .getter(getter(DescribeReplicationInstancesResponse::replicationInstances))
            .setter(setter(Builder::replicationInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            REPLICATION_INSTANCES_FIELD));

    private final String marker;

    private final List<ReplicationInstance> replicationInstances;

    private DescribeReplicationInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationInstances = builder.replicationInstances;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the ReplicationInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReplicationInstances() {
        return replicationInstances != null && !(replicationInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication instances described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The replication instances described.
     */
    public final List<ReplicationInstance> replicationInstances() {
        return replicationInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationInstances() ? replicationInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationInstancesResponse)) {
            return false;
        }
        DescribeReplicationInstancesResponse other = (DescribeReplicationInstancesResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasReplicationInstances() == other.hasReplicationInstances()
                && Objects.equals(replicationInstances(), other.replicationInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicationInstancesResponse").add("Marker", marker())
                .add("ReplicationInstances", hasReplicationInstances() ? replicationInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReplicationInstances":
            return Optional.ofNullable(clazz.cast(replicationInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReplicationInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationInstancesResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The replication instances described.
         * </p>
         * 
         * @param replicationInstances
         *        The replication instances described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstances(Collection<ReplicationInstance> replicationInstances);

        /**
         * <p>
         * The replication instances described.
         * </p>
         * 
         * @param replicationInstances
         *        The replication instances described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstances(ReplicationInstance... replicationInstances);

        /**
         * <p>
         * The replication instances described.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationInstance>.Builder} avoiding the
         * need to create one manually via {@link List<ReplicationInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationInstance>.Builder#build()} is called immediately
         * and its result is passed to {@link #replicationInstances(List<ReplicationInstance>)}.
         * 
         * @param replicationInstances
         *        a consumer that will call methods on {@link List<ReplicationInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationInstances(List<ReplicationInstance>)
         */
        Builder replicationInstances(Consumer<ReplicationInstance.Builder>... replicationInstances);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReplicationInstance> replicationInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationInstancesResponse model) {
            super(model);
            marker(model.marker);
            replicationInstances(model.replicationInstances);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<ReplicationInstance.Builder> getReplicationInstances() {
            List<ReplicationInstance.Builder> result = ReplicationInstanceListCopier.copyToBuilder(this.replicationInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicationInstances(Collection<ReplicationInstance> replicationInstances) {
            this.replicationInstances = ReplicationInstanceListCopier.copy(replicationInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstances(ReplicationInstance... replicationInstances) {
            replicationInstances(Arrays.asList(replicationInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstances(Consumer<ReplicationInstance.Builder>... replicationInstances) {
            replicationInstances(Stream.of(replicationInstances).map(c -> ReplicationInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationInstances(Collection<ReplicationInstance.BuilderImpl> replicationInstances) {
            this.replicationInstances = ReplicationInstanceListCopier.copyFromBuilder(replicationInstances);
        }

        @Override
        public DescribeReplicationInstancesResponse build() {
            return new DescribeReplicationInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
