/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventSubscriptionRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<CreateEventSubscriptionRequest.Builder, CreateEventSubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionName").getter(getter(CreateEventSubscriptionRequest::subscriptionName))
            .setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(CreateEventSubscriptionRequest::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(CreateEventSubscriptionRequest::sourceType))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventCategories")
            .getter(getter(CreateEventSubscriptionRequest::eventCategories))
            .setter(setter(Builder::eventCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceIds")
            .getter(getter(CreateEventSubscriptionRequest::sourceIds))
            .setter(setter(Builder::sourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CreateEventSubscriptionRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEventSubscriptionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_NAME_FIELD,
            SNS_TOPIC_ARN_FIELD, SOURCE_TYPE_FIELD, EVENT_CATEGORIES_FIELD, SOURCE_IDS_FIELD, ENABLED_FIELD, TAGS_FIELD));

    private final String subscriptionName;

    private final String snsTopicArn;

    private final String sourceType;

    private final List<String> eventCategories;

    private final List<String> sourceIds;

    private final Boolean enabled;

    private final List<Tag> tags;

    private CreateEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
        this.sourceIds = builder.sourceIds;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the AWS DMS event notification subscription. This name must be less than 255 characters.
     * </p>
     * 
     * @return The name of the AWS DMS event notification subscription. This name must be less than 255 characters.
     */
    public final String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by
     * Amazon SNS when you create a topic and subscribe to it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created
     *         by Amazon SNS when you create a topic and subscribe to it.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The type of AWS DMS resource that generates the events. For example, if you want to be notified of events
     * generated by a replication instance, you set this parameter to <code>replication-instance</code>. If this value
     * isn't specified, all events are returned.
     * </p>
     * <p>
     * Valid values: <code>replication-instance</code> | <code>replication-task</code>
     * </p>
     * 
     * @return The type of AWS DMS resource that generates the events. For example, if you want to be notified of events
     *         generated by a replication instance, you set this parameter to <code>replication-instance</code>. If this
     *         value isn't specified, all events are returned. </p>
     *         <p>
     *         Valid values: <code>replication-instance</code> | <code>replication-task</code>
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * Returns true if the EventCategories property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEventCategories() {
        return eventCategories != null && !(eventCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event categories for a source type that you want to subscribe to. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>AWS Database Migration Service User Guide.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event categories for a source type that you want to subscribe to. For more information, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     *         Notifications</a> in the <i>AWS Database Migration Service User Guide.</i>
     */
    public final List<String> eventCategories() {
        return eventCategories;
    }

    /**
     * Returns true if the SourceIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSourceIds() {
        return sourceIds != null && !(sourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers for which AWS DMS provides notification events.
     * </p>
     * <p>
     * If you don't specify a value, notifications are provided for all sources.
     * </p>
     * <p>
     * If you specify multiple values, they must be of the same type. For example, if you specify a database instance
     * ID, then all of the other values must be database instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of identifiers for which AWS DMS provides notification events.</p>
     *         <p>
     *         If you don't specify a value, notifications are provided for all sources.
     *         </p>
     *         <p>
     *         If you specify multiple values, they must be of the same type. For example, if you specify a database
     *         instance ID, then all of the other values must be database instance IDs.
     */
    public final List<String> sourceIds() {
        return sourceIds;
    }

    /**
     * <p>
     * A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code> to create
     * the subscription but not activate it.
     * </p>
     * 
     * @return A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code> to
     *         create the subscription but not activate it.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags to be assigned to the event subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags to be assigned to the event subscription.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventCategories() ? eventCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceIds() ? sourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSubscriptionRequest)) {
            return false;
        }
        CreateEventSubscriptionRequest other = (CreateEventSubscriptionRequest) obj;
        return Objects.equals(subscriptionName(), other.subscriptionName()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(sourceType(), other.sourceType()) && hasEventCategories() == other.hasEventCategories()
                && Objects.equals(eventCategories(), other.eventCategories()) && hasSourceIds() == other.hasSourceIds()
                && Objects.equals(sourceIds(), other.sourceIds()) && Objects.equals(enabled(), other.enabled())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventSubscriptionRequest").add("SubscriptionName", subscriptionName())
                .add("SnsTopicArn", snsTopicArn()).add("SourceType", sourceType())
                .add("EventCategories", hasEventCategories() ? eventCategories() : null)
                .add("SourceIds", hasSourceIds() ? sourceIds() : null).add("Enabled", enabled())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "EventCategories":
            return Optional.ofNullable(clazz.cast(eventCategories()));
        case "SourceIds":
            return Optional.ofNullable(clazz.cast(sourceIds()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateEventSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEventSubscriptionRequest> {
        /**
         * <p>
         * The name of the AWS DMS event notification subscription. This name must be less than 255 characters.
         * </p>
         * 
         * @param subscriptionName
         *        The name of the AWS DMS event notification subscription. This name must be less than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by
         * Amazon SNS when you create a topic and subscribe to it.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is
         *        created by Amazon SNS when you create a topic and subscribe to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The type of AWS DMS resource that generates the events. For example, if you want to be notified of events
         * generated by a replication instance, you set this parameter to <code>replication-instance</code>. If this
         * value isn't specified, all events are returned.
         * </p>
         * <p>
         * Valid values: <code>replication-instance</code> | <code>replication-task</code>
         * </p>
         * 
         * @param sourceType
         *        The type of AWS DMS resource that generates the events. For example, if you want to be notified of
         *        events generated by a replication instance, you set this parameter to
         *        <code>replication-instance</code>. If this value isn't specified, all events are returned. </p>
         *        <p>
         *        Valid values: <code>replication-instance</code> | <code>replication-task</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * A list of event categories for a source type that you want to subscribe to. For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
         * Notifications</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param eventCategories
         *        A list of event categories for a source type that you want to subscribe to. For more information, see
         *        <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
         *        Notifications</a> in the <i>AWS Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(Collection<String> eventCategories);

        /**
         * <p>
         * A list of event categories for a source type that you want to subscribe to. For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
         * Notifications</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param eventCategories
         *        A list of event categories for a source type that you want to subscribe to. For more information, see
         *        <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
         *        Notifications</a> in the <i>AWS Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(String... eventCategories);

        /**
         * <p>
         * A list of identifiers for which AWS DMS provides notification events.
         * </p>
         * <p>
         * If you don't specify a value, notifications are provided for all sources.
         * </p>
         * <p>
         * If you specify multiple values, they must be of the same type. For example, if you specify a database
         * instance ID, then all of the other values must be database instance IDs.
         * </p>
         * 
         * @param sourceIds
         *        A list of identifiers for which AWS DMS provides notification events.</p>
         *        <p>
         *        If you don't specify a value, notifications are provided for all sources.
         *        </p>
         *        <p>
         *        If you specify multiple values, they must be of the same type. For example, if you specify a database
         *        instance ID, then all of the other values must be database instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIds(Collection<String> sourceIds);

        /**
         * <p>
         * A list of identifiers for which AWS DMS provides notification events.
         * </p>
         * <p>
         * If you don't specify a value, notifications are provided for all sources.
         * </p>
         * <p>
         * If you specify multiple values, they must be of the same type. For example, if you specify a database
         * instance ID, then all of the other values must be database instance IDs.
         * </p>
         * 
         * @param sourceIds
         *        A list of identifiers for which AWS DMS provides notification events.</p>
         *        <p>
         *        If you don't specify a value, notifications are provided for all sources.
         *        </p>
         *        <p>
         *        If you specify multiple values, they must be of the same type. For example, if you specify a database
         *        instance ID, then all of the other values must be database instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIds(String... sourceIds);

        /**
         * <p>
         * A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code> to
         * create the subscription but not activate it.
         * </p>
         * 
         * @param enabled
         *        A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code>
         *        to create the subscription but not activate it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * One or more tags to be assigned to the event subscription.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the event subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags to be assigned to the event subscription.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the event subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags to be assigned to the event subscription.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String subscriptionName;

        private String snsTopicArn;

        private String sourceType;

        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourceIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSubscriptionRequest model) {
            super(model);
            subscriptionName(model.subscriptionName);
            snsTopicArn(model.snsTopicArn);
            sourceType(model.sourceType);
            eventCategories(model.eventCategories);
            sourceIds(model.sourceIds);
            enabled(model.enabled);
            tags(model.tags);
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getEventCategories() {
            if (eventCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String... eventCategories) {
            eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final Collection<String> getSourceIds() {
            if (sourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceIds;
        }

        @Override
        public final Builder sourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIds(String... sourceIds) {
            sourceIds(Arrays.asList(sourceIds));
            return this;
        }

        public final void setSourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventSubscriptionRequest build() {
            return new CreateEventSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
