/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantRequest;
import software.amazon.awssdk.services.connectparticipant.model.ConnectionType;
import software.amazon.awssdk.services.connectparticipant.model.ConnectionTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateParticipantConnectionRequest
extends ConnectParticipantRequest
implements ToCopyableBuilder<Builder, CreateParticipantConnectionRequest> {
    private static final SdkField<List<String>> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Type").getter(CreateParticipantConnectionRequest.getter(CreateParticipantConnectionRequest::typeAsStrings)).setter(CreateParticipantConnectionRequest.setter(Builder::typeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantToken").getter(CreateParticipantConnectionRequest.getter(CreateParticipantConnectionRequest::participantToken)).setter(CreateParticipantConnectionRequest.setter(Builder::participantToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PARTICIPANT_TOKEN_FIELD));
    private final List<String> type;
    private final String participantToken;

    private CreateParticipantConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.participantToken = builder.participantToken;
    }

    public final List<ConnectionType> type() {
        return ConnectionTypeListCopier.copyStringToEnum(this.type);
    }

    public final boolean hasType() {
        return this.type != null && !(this.type instanceof SdkAutoConstructList);
    }

    public final List<String> typeAsStrings() {
        return this.type;
    }

    public final String participantToken() {
        return this.participantToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasType() ? this.typeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.participantToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantConnectionRequest)) {
            return false;
        }
        CreateParticipantConnectionRequest other = (CreateParticipantConnectionRequest)((Object)obj);
        return this.hasType() == other.hasType() && Objects.equals(this.typeAsStrings(), other.typeAsStrings()) && Objects.equals(this.participantToken(), other.participantToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateParticipantConnectionRequest").add("Type", this.hasType() ? this.typeAsStrings() : null).add("ParticipantToken", (Object)this.participantToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsStrings()));
            }
            case "ParticipantToken": {
                return Optional.ofNullable(clazz.cast(this.participantToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantConnectionRequest, T> g) {
        return obj -> g.apply((CreateParticipantConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantRequest.BuilderImpl
    implements Builder {
        private List<String> type = DefaultSdkAutoConstructList.getInstance();
        private String participantToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantConnectionRequest model) {
            super(model);
            this.typeWithStrings(model.type);
            this.participantToken(model.participantToken);
        }

        public final Collection<String> getType() {
            if (this.type instanceof SdkAutoConstructList) {
                return null;
            }
            return this.type;
        }

        @Override
        public final Builder typeWithStrings(Collection<String> type) {
            this.type = ConnectionTypeListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeWithStrings(String ... type) {
            this.typeWithStrings(Arrays.asList(type));
            return this;
        }

        @Override
        public final Builder type(Collection<ConnectionType> type) {
            this.type = ConnectionTypeListCopier.copyEnumToString(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(ConnectionType ... type) {
            this.type(Arrays.asList(type));
            return this;
        }

        public final void setType(Collection<String> type) {
            this.type = ConnectionTypeListCopier.copy(type);
        }

        public final String getParticipantToken() {
            return this.participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateParticipantConnectionRequest build() {
            return new CreateParticipantConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectParticipantRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateParticipantConnectionRequest> {
        public Builder typeWithStrings(Collection<String> var1);

        public Builder typeWithStrings(String ... var1);

        public Builder type(Collection<ConnectionType> var1);

        public Builder type(ConnectionType ... var1);

        public Builder participantToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

