/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityUsage> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(IdentityUsage.getter(IdentityUsage::identityId)).setter(IdentityUsage.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(IdentityUsage.getter(IdentityUsage::identityPoolId)).setter(IdentityUsage.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(IdentityUsage.getter(IdentityUsage::lastModifiedDate)).setter(IdentityUsage.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<Integer> DATASET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatasetCount").getter(IdentityUsage.getter(IdentityUsage::datasetCount)).setter(IdentityUsage.setter(Builder::datasetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetCount").build()}).build();
    private static final SdkField<Long> DATA_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataStorage").getter(IdentityUsage.getter(IdentityUsage::dataStorage)).setter(IdentityUsage.setter(Builder::dataStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD, IDENTITY_POOL_ID_FIELD, LAST_MODIFIED_DATE_FIELD, DATASET_COUNT_FIELD, DATA_STORAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identityId;
    private final String identityPoolId;
    private final Instant lastModifiedDate;
    private final Integer datasetCount;
    private final Long dataStorage;

    private IdentityUsage(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.datasetCount = builder.datasetCount;
        this.dataStorage = builder.dataStorage;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Integer datasetCount() {
        return this.datasetCount;
    }

    public final Long dataStorage() {
        return this.dataStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityUsage)) {
            return false;
        }
        IdentityUsage other = (IdentityUsage)obj;
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.datasetCount(), other.datasetCount()) && Objects.equals(this.dataStorage(), other.dataStorage());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityUsage").add("IdentityId", (Object)this.identityId()).add("IdentityPoolId", (Object)this.identityPoolId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("DatasetCount", (Object)this.datasetCount()).add("DataStorage", (Object)this.dataStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "DatasetCount": {
                return Optional.ofNullable(clazz.cast(this.datasetCount()));
            }
            case "DataStorage": {
                return Optional.ofNullable(clazz.cast(this.dataStorage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityUsage, T> g) {
        return obj -> g.apply((IdentityUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityId;
        private String identityPoolId;
        private Instant lastModifiedDate;
        private Integer datasetCount;
        private Long dataStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityUsage model) {
            this.identityId(model.identityId);
            this.identityPoolId(model.identityPoolId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.datasetCount(model.datasetCount);
            this.dataStorage(model.dataStorage);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getDatasetCount() {
            return this.datasetCount;
        }

        @Override
        public final Builder datasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
            return this;
        }

        public final void setDatasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
        }

        public final Long getDataStorage() {
            return this.dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        public IdentityUsage build() {
            return new IdentityUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityUsage> {
        public Builder identityId(String var1);

        public Builder identityPoolId(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder datasetCount(Integer var1);

        public Builder dataStorage(Long var1);
    }
}

