/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the polling configuration for the <code>JobWorker</code> action engine, or executor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobWorkerExecutorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<JobWorkerExecutorConfiguration.Builder, JobWorkerExecutorConfiguration> {
    private static final SdkField<List<String>> POLLING_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("pollingAccounts")
            .getter(getter(JobWorkerExecutorConfiguration::pollingAccounts))
            .setter(setter(Builder::pollingAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pollingAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> POLLING_SERVICE_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("pollingServicePrincipals")
            .getter(getter(JobWorkerExecutorConfiguration::pollingServicePrincipals))
            .setter(setter(Builder::pollingServicePrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pollingServicePrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLLING_ACCOUNTS_FIELD,
            POLLING_SERVICE_PRINCIPALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> pollingAccounts;

    private final List<String> pollingServicePrincipals;

    private JobWorkerExecutorConfiguration(BuilderImpl builder) {
        this.pollingAccounts = builder.pollingAccounts;
        this.pollingServicePrincipals = builder.pollingServicePrincipals;
    }

    /**
     * Returns true if the PollingAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPollingAccounts() {
        return pollingAccounts != null && !(pollingAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accounts in which the job worker is configured and might poll for jobs as part of the action execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPollingAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The accounts in which the job worker is configured and might poll for jobs as part of the action
     *         execution.
     */
    public final List<String> pollingAccounts() {
        return pollingAccounts;
    }

    /**
     * Returns true if the PollingServicePrincipals property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPollingServicePrincipals() {
        return pollingServicePrincipals != null && !(pollingServicePrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The service Principals in which the job worker is configured and might poll for jobs as part of the action
     * execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPollingServicePrincipals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The service Principals in which the job worker is configured and might poll for jobs as part of the
     *         action execution.
     */
    public final List<String> pollingServicePrincipals() {
        return pollingServicePrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPollingAccounts() ? pollingAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPollingServicePrincipals() ? pollingServicePrincipals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobWorkerExecutorConfiguration)) {
            return false;
        }
        JobWorkerExecutorConfiguration other = (JobWorkerExecutorConfiguration) obj;
        return hasPollingAccounts() == other.hasPollingAccounts() && Objects.equals(pollingAccounts(), other.pollingAccounts())
                && hasPollingServicePrincipals() == other.hasPollingServicePrincipals()
                && Objects.equals(pollingServicePrincipals(), other.pollingServicePrincipals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobWorkerExecutorConfiguration")
                .add("PollingAccounts", hasPollingAccounts() ? pollingAccounts() : null)
                .add("PollingServicePrincipals", hasPollingServicePrincipals() ? pollingServicePrincipals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pollingAccounts":
            return Optional.ofNullable(clazz.cast(pollingAccounts()));
        case "pollingServicePrincipals":
            return Optional.ofNullable(clazz.cast(pollingServicePrincipals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobWorkerExecutorConfiguration, T> g) {
        return obj -> g.apply((JobWorkerExecutorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobWorkerExecutorConfiguration> {
        /**
         * <p>
         * The accounts in which the job worker is configured and might poll for jobs as part of the action execution.
         * </p>
         * 
         * @param pollingAccounts
         *        The accounts in which the job worker is configured and might poll for jobs as part of the action
         *        execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pollingAccounts(Collection<String> pollingAccounts);

        /**
         * <p>
         * The accounts in which the job worker is configured and might poll for jobs as part of the action execution.
         * </p>
         * 
         * @param pollingAccounts
         *        The accounts in which the job worker is configured and might poll for jobs as part of the action
         *        execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pollingAccounts(String... pollingAccounts);

        /**
         * <p>
         * The service Principals in which the job worker is configured and might poll for jobs as part of the action
         * execution.
         * </p>
         * 
         * @param pollingServicePrincipals
         *        The service Principals in which the job worker is configured and might poll for jobs as part of the
         *        action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pollingServicePrincipals(Collection<String> pollingServicePrincipals);

        /**
         * <p>
         * The service Principals in which the job worker is configured and might poll for jobs as part of the action
         * execution.
         * </p>
         * 
         * @param pollingServicePrincipals
         *        The service Principals in which the job worker is configured and might poll for jobs as part of the
         *        action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pollingServicePrincipals(String... pollingServicePrincipals);
    }

    static final class BuilderImpl implements Builder {
        private List<String> pollingAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> pollingServicePrincipals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobWorkerExecutorConfiguration model) {
            pollingAccounts(model.pollingAccounts);
            pollingServicePrincipals(model.pollingServicePrincipals);
        }

        public final Collection<String> getPollingAccounts() {
            if (pollingAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return pollingAccounts;
        }

        @Override
        public final Builder pollingAccounts(Collection<String> pollingAccounts) {
            this.pollingAccounts = PollingAccountListCopier.copy(pollingAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pollingAccounts(String... pollingAccounts) {
            pollingAccounts(Arrays.asList(pollingAccounts));
            return this;
        }

        public final void setPollingAccounts(Collection<String> pollingAccounts) {
            this.pollingAccounts = PollingAccountListCopier.copy(pollingAccounts);
        }

        public final Collection<String> getPollingServicePrincipals() {
            if (pollingServicePrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return pollingServicePrincipals;
        }

        @Override
        public final Builder pollingServicePrincipals(Collection<String> pollingServicePrincipals) {
            this.pollingServicePrincipals = PollingServicePrincipalListCopier.copy(pollingServicePrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pollingServicePrincipals(String... pollingServicePrincipals) {
            pollingServicePrincipals(Arrays.asList(pollingServicePrincipals));
            return this;
        }

        public final void setPollingServicePrincipals(Collection<String> pollingServicePrincipals) {
            this.pollingServicePrincipals = PollingServicePrincipalListCopier.copy(pollingServicePrincipals);
        }

        @Override
        public JobWorkerExecutorConfiguration build() {
            return new JobWorkerExecutorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
