/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetPipelineState</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPipelineStateResponse extends CodePipelineResponse implements
        ToCopyableBuilder<GetPipelineStateResponse.Builder, GetPipelineStateResponse> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(GetPipelineStateResponse::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pipelineVersion").getter(getter(GetPipelineStateResponse::pipelineVersion))
            .setter(setter(Builder::pipelineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()).build();

    private static final SdkField<List<StageState>> STAGE_STATES_FIELD = SdkField
            .<List<StageState>> builder(MarshallingType.LIST)
            .memberName("stageStates")
            .getter(getter(GetPipelineStateResponse::stageStates))
            .setter(setter(Builder::stageStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StageState> builder(MarshallingType.SDK_POJO)
                                            .constructor(StageState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(GetPipelineStateResponse::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updated").getter(getter(GetPipelineStateResponse::updated)).setter(setter(Builder::updated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            PIPELINE_VERSION_FIELD, STAGE_STATES_FIELD, CREATED_FIELD, UPDATED_FIELD));

    private final String pipelineName;

    private final Integer pipelineVersion;

    private final List<StageState> stageStates;

    private final Instant created;

    private final Instant updated;

    private GetPipelineStateResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageStates = builder.stageStates;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    /**
     * <p>
     * The name of the pipeline for which you want to get the state.
     * </p>
     * 
     * @return The name of the pipeline for which you want to get the state.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The version number of the pipeline.
     * </p>
     * <note>
     * <p>
     * A newly created pipeline is always assigned a version number of <code>1</code>.
     * </p>
     * </note>
     * 
     * @return The version number of the pipeline.</p> <note>
     *         <p>
     *         A newly created pipeline is always assigned a version number of <code>1</code>.
     *         </p>
     */
    public final Integer pipelineVersion() {
        return pipelineVersion;
    }

    /**
     * Returns true if the StageStates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStageStates() {
        return stageStates != null && !(stageStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the pipeline stage output information, including stage name, state, most recent run details, whether
     * the stage is disabled, and other data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStageStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the pipeline stage output information, including stage name, state, most recent run details,
     *         whether the stage is disabled, and other data.
     */
    public final List<StageState> stageStates() {
        return stageStates;
    }

    /**
     * <p>
     * The date and time the pipeline was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the pipeline was created, in timestamp format.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time the pipeline was last updated, in timestamp format.
     * </p>
     * 
     * @return The date and time the pipeline was last updated, in timestamp format.
     */
    public final Instant updated() {
        return updated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasStageStates() ? stageStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(updated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineStateResponse)) {
            return false;
        }
        GetPipelineStateResponse other = (GetPipelineStateResponse) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(pipelineVersion(), other.pipelineVersion())
                && hasStageStates() == other.hasStageStates() && Objects.equals(stageStates(), other.stageStates())
                && Objects.equals(created(), other.created()) && Objects.equals(updated(), other.updated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPipelineStateResponse").add("PipelineName", pipelineName())
                .add("PipelineVersion", pipelineVersion()).add("StageStates", hasStageStates() ? stageStates() : null)
                .add("Created", created()).add("Updated", updated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "pipelineVersion":
            return Optional.ofNullable(clazz.cast(pipelineVersion()));
        case "stageStates":
            return Optional.ofNullable(clazz.cast(stageStates()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "updated":
            return Optional.ofNullable(clazz.cast(updated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineStateResponse, T> g) {
        return obj -> g.apply((GetPipelineStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPipelineStateResponse> {
        /**
         * <p>
         * The name of the pipeline for which you want to get the state.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline for which you want to get the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The version number of the pipeline.
         * </p>
         * <note>
         * <p>
         * A newly created pipeline is always assigned a version number of <code>1</code>.
         * </p>
         * </note>
         * 
         * @param pipelineVersion
         *        The version number of the pipeline.</p> <note>
         *        <p>
         *        A newly created pipeline is always assigned a version number of <code>1</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersion(Integer pipelineVersion);

        /**
         * <p>
         * A list of the pipeline stage output information, including stage name, state, most recent run details,
         * whether the stage is disabled, and other data.
         * </p>
         * 
         * @param stageStates
         *        A list of the pipeline stage output information, including stage name, state, most recent run details,
         *        whether the stage is disabled, and other data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageStates(Collection<StageState> stageStates);

        /**
         * <p>
         * A list of the pipeline stage output information, including stage name, state, most recent run details,
         * whether the stage is disabled, and other data.
         * </p>
         * 
         * @param stageStates
         *        A list of the pipeline stage output information, including stage name, state, most recent run details,
         *        whether the stage is disabled, and other data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageStates(StageState... stageStates);

        /**
         * <p>
         * A list of the pipeline stage output information, including stage name, state, most recent run details,
         * whether the stage is disabled, and other data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StageState>.Builder} avoiding the need to
         * create one manually via {@link List<StageState>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StageState>.Builder#build()} is called immediately and its
         * result is passed to {@link #stageStates(List<StageState>)}.
         * 
         * @param stageStates
         *        a consumer that will call methods on {@link List<StageState>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stageStates(List<StageState>)
         */
        Builder stageStates(Consumer<StageState.Builder>... stageStates);

        /**
         * <p>
         * The date and time the pipeline was created, in timestamp format.
         * </p>
         * 
         * @param created
         *        The date and time the pipeline was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time the pipeline was last updated, in timestamp format.
         * </p>
         * 
         * @param updated
         *        The date and time the pipeline was last updated, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updated(Instant updated);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private String pipelineName;

        private Integer pipelineVersion;

        private List<StageState> stageStates = DefaultSdkAutoConstructList.getInstance();

        private Instant created;

        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineStateResponse model) {
            super(model);
            pipelineName(model.pipelineName);
            pipelineVersion(model.pipelineVersion);
            stageStates(model.stageStates);
            created(model.created);
            updated(model.updated);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final Integer getPipelineVersion() {
            return pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        public final List<StageState.Builder> getStageStates() {
            List<StageState.Builder> result = StageStateListCopier.copyToBuilder(this.stageStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stageStates(Collection<StageState> stageStates) {
            this.stageStates = StageStateListCopier.copy(stageStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageStates(StageState... stageStates) {
            stageStates(Arrays.asList(stageStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageStates(Consumer<StageState.Builder>... stageStates) {
            stageStates(Stream.of(stageStates).map(c -> StageState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStageStates(Collection<StageState.BuilderImpl> stageStates) {
            this.stageStates = StageStateListCopier.copyFromBuilder(stageStates);
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getUpdated() {
            return updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        @Override
        public GetPipelineStateResponse build() {
            return new GetPipelineStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
