/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DisableStageTransition</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableStageTransitionRequest extends CodePipelineRequest implements
        ToCopyableBuilder<DisableStageTransitionRequest.Builder, DisableStageTransitionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(DisableStageTransitionRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(DisableStageTransitionRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> TRANSITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transitionType").getter(getter(DisableStageTransitionRequest::transitionTypeAsString))
            .setter(setter(Builder::transitionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitionType").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(DisableStageTransitionRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            STAGE_NAME_FIELD, TRANSITION_TYPE_FIELD, REASON_FIELD));

    private final String pipelineName;

    private final String stageName;

    private final String transitionType;

    private final String reason;

    private DisableStageTransitionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.transitionType = builder.transitionType;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
     * </p>
     * 
     * @return The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The name of the stage where you want to disable the inbound or outbound transition of artifacts.
     * </p>
     * 
     * @return The name of the stage where you want to disable the inbound or outbound transition of artifacts.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in
     * that stage (inbound), or prevented from transitioning from the stage after they have been processed by the
     * actions in that stage (outbound).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transitionType}
     * will return {@link StageTransitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #transitionTypeAsString}.
     * </p>
     * 
     * @return Specifies whether artifacts are prevented from transitioning into the stage and being processed by the
     *         actions in that stage (inbound), or prevented from transitioning from the stage after they have been
     *         processed by the actions in that stage (outbound).
     * @see StageTransitionType
     */
    public final StageTransitionType transitionType() {
        return StageTransitionType.fromValue(transitionType);
    }

    /**
     * <p>
     * Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in
     * that stage (inbound), or prevented from transitioning from the stage after they have been processed by the
     * actions in that stage (outbound).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transitionType}
     * will return {@link StageTransitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #transitionTypeAsString}.
     * </p>
     * 
     * @return Specifies whether artifacts are prevented from transitioning into the stage and being processed by the
     *         actions in that stage (inbound), or prevented from transitioning from the stage after they have been
     *         processed by the actions in that stage (outbound).
     * @see StageTransitionType
     */
    public final String transitionTypeAsString() {
        return transitionType;
    }

    /**
     * <p>
     * The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This
     * message is displayed in the pipeline console UI.
     * </p>
     * 
     * @return The reason given to the user that a stage is disabled, such as waiting for manual approval or manual
     *         tests. This message is displayed in the pipeline console UI.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(transitionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableStageTransitionRequest)) {
            return false;
        }
        DisableStageTransitionRequest other = (DisableStageTransitionRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(transitionTypeAsString(), other.transitionTypeAsString())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableStageTransitionRequest").add("PipelineName", pipelineName())
                .add("StageName", stageName()).add("TransitionType", transitionTypeAsString()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "transitionType":
            return Optional.ofNullable(clazz.cast(transitionTypeAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableStageTransitionRequest, T> g) {
        return obj -> g.apply((DisableStageTransitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableStageTransitionRequest> {
        /**
         * <p>
         * The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The name of the stage where you want to disable the inbound or outbound transition of artifacts.
         * </p>
         * 
         * @param stageName
         *        The name of the stage where you want to disable the inbound or outbound transition of artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * Specifies whether artifacts are prevented from transitioning into the stage and being processed by the
         * actions in that stage (inbound), or prevented from transitioning from the stage after they have been
         * processed by the actions in that stage (outbound).
         * </p>
         * 
         * @param transitionType
         *        Specifies whether artifacts are prevented from transitioning into the stage and being processed by the
         *        actions in that stage (inbound), or prevented from transitioning from the stage after they have been
         *        processed by the actions in that stage (outbound).
         * @see StageTransitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageTransitionType
         */
        Builder transitionType(String transitionType);

        /**
         * <p>
         * Specifies whether artifacts are prevented from transitioning into the stage and being processed by the
         * actions in that stage (inbound), or prevented from transitioning from the stage after they have been
         * processed by the actions in that stage (outbound).
         * </p>
         * 
         * @param transitionType
         *        Specifies whether artifacts are prevented from transitioning into the stage and being processed by the
         *        actions in that stage (inbound), or prevented from transitioning from the stage after they have been
         *        processed by the actions in that stage (outbound).
         * @see StageTransitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageTransitionType
         */
        Builder transitionType(StageTransitionType transitionType);

        /**
         * <p>
         * The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests.
         * This message is displayed in the pipeline console UI.
         * </p>
         * 
         * @param reason
         *        The reason given to the user that a stage is disabled, such as waiting for manual approval or manual
         *        tests. This message is displayed in the pipeline console UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String stageName;

        private String transitionType;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableStageTransitionRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            stageName(model.stageName);
            transitionType(model.transitionType);
            reason(model.reason);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getTransitionType() {
            return transitionType;
        }

        @Override
        public final Builder transitionType(String transitionType) {
            this.transitionType = transitionType;
            return this;
        }

        @Override
        public final Builder transitionType(StageTransitionType transitionType) {
            this.transitionType(transitionType == null ? null : transitionType.toString());
            return this;
        }

        public final void setTransitionType(String transitionType) {
            this.transitionType = transitionType;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableStageTransitionRequest build() {
            return new DisableStageTransitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
