/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about each property specified in the action configuration, such as the description and key
 * name that display for the customer using the action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTypeProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionTypeProperty.Builder, ActionTypeProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ActionTypeProperty::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> OPTIONAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("optional").getter(getter(ActionTypeProperty::optional)).setter(setter(Builder::optional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optional").build()).build();

    private static final SdkField<Boolean> KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("key")
            .getter(getter(ActionTypeProperty::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Boolean> NO_ECHO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("noEcho").getter(getter(ActionTypeProperty::noEcho)).setter(setter(Builder::noEcho))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noEcho").build()).build();

    private static final SdkField<Boolean> QUERYABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("queryable").getter(getter(ActionTypeProperty::queryable)).setter(setter(Builder::queryable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryable").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ActionTypeProperty::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OPTIONAL_FIELD,
            KEY_FIELD, NO_ECHO_FIELD, QUERYABLE_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Boolean optional;

    private final Boolean key;

    private final Boolean noEcho;

    private final Boolean queryable;

    private final String description;

    private ActionTypeProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.optional = builder.optional;
        this.key = builder.key;
        this.noEcho = builder.noEcho;
        this.queryable = builder.queryable;
        this.description = builder.description;
    }

    /**
     * <p>
     * The property name that is displayed to users.
     * </p>
     * 
     * @return The property name that is displayed to users.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Whether the configuration property is an optional value.
     * </p>
     * 
     * @return Whether the configuration property is an optional value.
     */
    public final Boolean optional() {
        return optional;
    }

    /**
     * <p>
     * Whether the configuration property is a key.
     * </p>
     * 
     * @return Whether the configuration property is a key.
     */
    public final Boolean key() {
        return key;
    }

    /**
     * <p>
     * Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is not saved
     * in CloudTrail logs for the action execution.
     * </p>
     * 
     * @return Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is
     *         not saved in CloudTrail logs for the action execution.
     */
    public final Boolean noEcho() {
        return noEcho;
    }

    /**
     * <p>
     * Indicates that the property is used with polling. An action type can have up to one queryable property. If it has
     * one, that property must be both required and not secret.
     * </p>
     * 
     * @return Indicates that the property is used with polling. An action type can have up to one queryable property.
     *         If it has one, that property must be both required and not secret.
     */
    public final Boolean queryable() {
        return queryable;
    }

    /**
     * <p>
     * The description of the property that is displayed to users.
     * </p>
     * 
     * @return The description of the property that is displayed to users.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(optional());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(queryable());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeProperty)) {
            return false;
        }
        ActionTypeProperty other = (ActionTypeProperty) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(optional(), other.optional())
                && Objects.equals(key(), other.key()) && Objects.equals(noEcho(), other.noEcho())
                && Objects.equals(queryable(), other.queryable()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionTypeProperty").add("Name", name()).add("Optional", optional()).add("Key", key())
                .add("NoEcho", noEcho()).add("Queryable", queryable()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "optional":
            return Optional.ofNullable(clazz.cast(optional()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "noEcho":
            return Optional.ofNullable(clazz.cast(noEcho()));
        case "queryable":
            return Optional.ofNullable(clazz.cast(queryable()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeProperty, T> g) {
        return obj -> g.apply((ActionTypeProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTypeProperty> {
        /**
         * <p>
         * The property name that is displayed to users.
         * </p>
         * 
         * @param name
         *        The property name that is displayed to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Whether the configuration property is an optional value.
         * </p>
         * 
         * @param optional
         *        Whether the configuration property is an optional value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optional(Boolean optional);

        /**
         * <p>
         * Whether the configuration property is a key.
         * </p>
         * 
         * @param key
         *        Whether the configuration property is a key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Boolean key);

        /**
         * <p>
         * Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is not
         * saved in CloudTrail logs for the action execution.
         * </p>
         * 
         * @param noEcho
         *        Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is
         *        not saved in CloudTrail logs for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noEcho(Boolean noEcho);

        /**
         * <p>
         * Indicates that the property is used with polling. An action type can have up to one queryable property. If it
         * has one, that property must be both required and not secret.
         * </p>
         * 
         * @param queryable
         *        Indicates that the property is used with polling. An action type can have up to one queryable
         *        property. If it has one, that property must be both required and not secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryable(Boolean queryable);

        /**
         * <p>
         * The description of the property that is displayed to users.
         * </p>
         * 
         * @param description
         *        The description of the property that is displayed to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Boolean optional;

        private Boolean key;

        private Boolean noEcho;

        private Boolean queryable;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeProperty model) {
            name(model.name);
            optional(model.optional);
            key(model.key);
            noEcho(model.noEcho);
            queryable(model.queryable);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getOptional() {
            return optional;
        }

        @Override
        public final Builder optional(Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final void setOptional(Boolean optional) {
            this.optional = optional;
        }

        public final Boolean getKey() {
            return key;
        }

        @Override
        public final Builder key(Boolean key) {
            this.key = key;
            return this;
        }

        public final void setKey(Boolean key) {
            this.key = key;
        }

        public final Boolean getNoEcho() {
            return noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final Boolean getQueryable() {
            return queryable;
        }

        @Override
        public final Builder queryable(Boolean queryable) {
            this.queryable = queryable;
            return this;
        }

        public final void setQueryable(Boolean queryable) {
            this.queryable = queryable;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public ActionTypeProperty build() {
            return new ActionTypeProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
