/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an AcknowledgeJob action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcknowledgeJobRequest extends CodePipelineRequest implements
        ToCopyableBuilder<AcknowledgeJobRequest.Builder, AcknowledgeJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(AcknowledgeJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> NONCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nonce")
            .getter(getter(AcknowledgeJobRequest::nonce)).setter(setter(Builder::nonce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonce").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, NONCE_FIELD));

    private final String jobId;

    private final String nonce;

    private AcknowledgeJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.nonce = builder.nonce;
    }

    /**
     * <p>
     * The unique system-generated ID of the job for which you want to confirm receipt.
     * </p>
     * 
     * @return The unique system-generated ID of the job for which you want to confirm receipt.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one
     * job worker. Get this number from the response of the <a>PollForJobs</a> request that returned this job.
     * </p>
     * 
     * @return A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by
     *         only one job worker. Get this number from the response of the <a>PollForJobs</a> request that returned
     *         this job.
     */
    public final String nonce() {
        return nonce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(nonce());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeJobRequest)) {
            return false;
        }
        AcknowledgeJobRequest other = (AcknowledgeJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(nonce(), other.nonce());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcknowledgeJobRequest").add("JobId", jobId()).add("Nonce", nonce()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "nonce":
            return Optional.ofNullable(clazz.cast(nonce()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcknowledgeJobRequest, T> g) {
        return obj -> g.apply((AcknowledgeJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, AcknowledgeJobRequest> {
        /**
         * <p>
         * The unique system-generated ID of the job for which you want to confirm receipt.
         * </p>
         * 
         * @param jobId
         *        The unique system-generated ID of the job for which you want to confirm receipt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only
         * one job worker. Get this number from the response of the <a>PollForJobs</a> request that returned this job.
         * </p>
         * 
         * @param nonce
         *        A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on
         *        by only one job worker. Get this number from the response of the <a>PollForJobs</a> request that
         *        returned this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonce(String nonce);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String jobId;

        private String nonce;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeJobRequest model) {
            super(model);
            jobId(model.jobId);
            nonce(model.nonce);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getNonce() {
            return nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcknowledgeJobRequest build() {
            return new AcknowledgeJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
