/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.RepositorySummary;

public class ListRepositoriesInDomainIterable
implements SdkIterable<ListRepositoriesInDomainResponse> {
    private final CodeartifactClient client;
    private final ListRepositoriesInDomainRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRepositoriesInDomainIterable(CodeartifactClient client, ListRepositoriesInDomainRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRepositoriesInDomainResponseFetcher();
    }

    public Iterator<ListRepositoriesInDomainResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RepositorySummary> repositories() {
        Function<ListRepositoriesInDomainResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRepositoriesInDomainResponseFetcher
    implements SyncPageFetcher<ListRepositoriesInDomainResponse> {
        private ListRepositoriesInDomainResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoriesInDomainResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRepositoriesInDomainResponse nextPage(ListRepositoriesInDomainResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoriesInDomainIterable.this.client.listRepositoriesInDomain(ListRepositoriesInDomainIterable.this.firstRequest);
            }
            return ListRepositoriesInDomainIterable.this.client.listRepositoriesInDomain((ListRepositoriesInDomainRequest)((Object)ListRepositoriesInDomainIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

