/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.Invalidation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInvalidationResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, CreateInvalidationResponse> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInvalidationResponse.getter(CreateInvalidationResponse::location)).setter(CreateInvalidationResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final SdkField<Invalidation> INVALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateInvalidationResponse.getter(CreateInvalidationResponse::invalidation)).setter(CreateInvalidationResponse.setter(Builder::invalidation)).constructor(Invalidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invalidation").unmarshallLocationName("Invalidation").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, INVALIDATION_FIELD));
    private final String location;
    private final Invalidation invalidation;

    private CreateInvalidationResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.invalidation = builder.invalidation;
    }

    public String location() {
        return this.location;
    }

    public Invalidation invalidation() {
        return this.invalidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationResponse)) {
            return false;
        }
        CreateInvalidationResponse other = (CreateInvalidationResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.invalidation(), other.invalidation());
    }

    public String toString() {
        return ToString.builder((String)"CreateInvalidationResponse").add("Location", (Object)this.location()).add("Invalidation", (Object)this.invalidation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Invalidation": {
                return Optional.ofNullable(clazz.cast(this.invalidation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInvalidationResponse, T> g) {
        return obj -> g.apply((CreateInvalidationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private String location;
        private Invalidation invalidation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationResponse model) {
            super(model);
            this.location(model.location);
            this.invalidation(model.invalidation);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Invalidation.Builder getInvalidation() {
            return this.invalidation != null ? this.invalidation.toBuilder() : null;
        }

        @Override
        public final Builder invalidation(Invalidation invalidation) {
            this.invalidation = invalidation;
            return this;
        }

        public final void setInvalidation(Invalidation.BuilderImpl invalidation) {
            this.invalidation = invalidation != null ? invalidation.build() : null;
        }

        @Override
        public CreateInvalidationResponse build() {
            return new CreateInvalidationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInvalidationResponse> {
        public Builder location(String var1);

        public Builder invalidation(Invalidation var1);

        default public Builder invalidation(Consumer<Invalidation.Builder> invalidation) {
            return this.invalidation((Invalidation)((Invalidation.Builder)Invalidation.builder().applyMutation(invalidation)).build());
        }
    }
}

