/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.Format;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentTypeProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentTypeProfile> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContentTypeProfile.getter(ContentTypeProfile::formatAsString)).setter(ContentTypeProfile.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("Format").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContentTypeProfile.getter(ContentTypeProfile::profileId)).setter(ContentTypeProfile.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").unmarshallLocationName("ProfileId").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContentTypeProfile.getter(ContentTypeProfile::contentType)).setter(ContentTypeProfile.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").unmarshallLocationName("ContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, PROFILE_ID_FIELD, CONTENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String profileId;
    private final String contentType;

    private ContentTypeProfile(BuilderImpl builder) {
        this.format = builder.format;
        this.profileId = builder.profileId;
        this.contentType = builder.contentType;
    }

    public Format format() {
        return Format.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String profileId() {
        return this.profileId;
    }

    public String contentType() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentTypeProfile)) {
            return false;
        }
        ContentTypeProfile other = (ContentTypeProfile)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.contentType(), other.contentType());
    }

    public String toString() {
        return ToString.builder((String)"ContentTypeProfile").add("Format", (Object)this.formatAsString()).add("ProfileId", (Object)this.profileId()).add("ContentType", (Object)this.contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentTypeProfile, T> g) {
        return obj -> g.apply((ContentTypeProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String profileId;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentTypeProfile model) {
            this.format(model.format);
            this.profileId(model.profileId);
            this.contentType(model.contentType);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public ContentTypeProfile build() {
            return new ContentTypeProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentTypeProfile> {
        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder profileId(String var1);

        public Builder contentType(String var1);
    }
}

