/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ThresholdType {
    PERCENTAGE("PERCENTAGE"),
    ABSOLUTE_VALUE("ABSOLUTE_VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ThresholdType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThresholdType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ThresholdType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThresholdType> knownValues() {
        return Stream.of(ThresholdType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

