/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ApiCacheType {
    T2_SMALL("T2_SMALL"),
    T2_MEDIUM("T2_MEDIUM"),
    R4_LARGE("R4_LARGE"),
    R4_XLARGE("R4_XLARGE"),
    R4_2_XLARGE("R4_2XLARGE"),
    R4_4_XLARGE("R4_4XLARGE"),
    R4_8_XLARGE("R4_8XLARGE"),
    SMALL("SMALL"),
    MEDIUM("MEDIUM"),
    LARGE("LARGE"),
    XLARGE("XLARGE"),
    LARGE_2_X("LARGE_2X"),
    LARGE_4_X("LARGE_4X"),
    LARGE_8_X("LARGE_8X"),
    LARGE_12_X("LARGE_12X"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ApiCacheType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiCacheType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ApiCacheType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiCacheType> knownValues() {
        return Stream.of(ApiCacheType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

